/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EclipseRunGenerator
extends RunConfigGenerator.XMLConfigurationBuilder {
    @Override
    @Nonnull
    protected Map<String, Document> createRunConfiguration(@Nonnull Project project, @Nonnull RunConfig runConfig, @Nonnull DocumentBuilder documentBuilder, List<String> additionalClientArgs) {
        LinkedHashMap<String, Document> documents = new LinkedHashMap<String, Document>();
        Map<String, Supplier<String>> updatedTokens = EclipseRunGenerator.configureTokensLazy(project, runConfig, EclipseRunGenerator.mapModClassesToEclipse(project, runConfig));
        File workingDirectory = new File(runConfig.getWorkingDirectory());
        if (!workingDirectory.exists()) {
            workingDirectory.mkdirs();
        }
        Document javaDocument = documentBuilder.newDocument();
        Element rootElement = javaDocument.createElement("launchConfiguration");
        rootElement.setAttribute("type", "org.eclipse.jdt.launching.localJavaApplication");
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROJECT_ATTR", project.getName());
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.MAIN_TYPE", runConfig.getMain());
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.VM_ARGUMENTS", EclipseRunGenerator.getJvmArgs(runConfig, additionalClientArgs, updatedTokens));
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", EclipseRunGenerator.getArgs(runConfig, updatedTokens));
        EclipseRunGenerator.elementAttribute(javaDocument, rootElement, "string", "org.eclipse.jdt.launching.WORKING_DIRECTORY", runConfig.getWorkingDirectory());
        Element envs = javaDocument.createElement("mapAttribute");
        envs.setAttribute("key", "org.eclipse.debug.core.environmentVariables");
        runConfig.getEnvironment().forEach((name, value) -> {
            Element envEntry = javaDocument.createElement("mapEntry");
            envEntry.setAttribute("key", (String)name);
            envEntry.setAttribute("value", runConfig.replace(updatedTokens, (String)value));
            envs.appendChild(envEntry);
        });
        rootElement.appendChild(envs);
        javaDocument.appendChild(rootElement);
        documents.put(runConfig.getTaskName() + ".launch", javaDocument);
        return documents;
    }

    static Stream<String> mapModClassesToEclipse(@Nonnull Project project, @Nonnull RunConfig runConfig) {
        EclipseModel eclipse = (EclipseModel)project.getExtensions().findByType(EclipseModel.class);
        Map<String, String> outputs = eclipse.getClasspath().resolveDependencies().stream().filter(SourceFolder.class::isInstance).map(SourceFolder.class::cast).map(SourceFolder::getOutput).distinct().collect(Collectors.toMap(output -> output.split("/")[output.split("/").length - 1], output -> project.file(output).getAbsolutePath()));
        if (runConfig.getMods().isEmpty()) {
            return runConfig.getAllSources().stream().map(SourceSet::getName).filter(outputs::containsKey).map(outputs::get).map(s -> String.join((CharSequence)File.pathSeparator, s, s));
        }
        SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        return runConfig.getMods().stream().map(modConfig -> (modConfig.getSources().isEmpty() ? Stream.of(main) : modConfig.getSources().stream()).map(SourceSet::getName).filter(outputs::containsKey).map(outputs::get).map(output -> modConfig.getName() + "%%" + output).map(s -> String.join((CharSequence)File.pathSeparator, s, s))).flatMap(Function.identity());
    }
}

