/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;

class ListLibrariesFunction
implements MCPFunction {
    ListLibrariesFunction() {
    }

    @Override
    public File execute(MCPEnvironment environment) {
        File output = (File)environment.getArguments().computeIfAbsent("output", key -> environment.getFile("libraries.txt"));
        try {
            Gson gson = new Gson();
            FileReader reader = new FileReader(environment.getStepOutput("downloadJson"));
            JsonObject json = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            ((Reader)reader).close();
            HashSet<File> files = new HashSet<File>();
            for (JsonElement libElement : json.getAsJsonArray("libraries")) {
                JsonObject library = libElement.getAsJsonObject();
                String name = library.get("name").getAsString();
                ArrayList<String> lst = new ArrayList<String>();
                if (library.has("downloads")) {
                    JsonObject downloads = library.get("downloads").getAsJsonObject();
                    if (downloads.has("artifact")) {
                        lst.add(name);
                    }
                    if (downloads.has("classifiers")) {
                        downloads.get("classifiers").getAsJsonObject().keySet().forEach(cls -> lst.add(name + ':' + cls));
                    }
                }
                for (String artifact : lst) {
                    File lib = MavenArtifactDownloader.gradle(environment.project, artifact, false);
                    if (lib == null) {
                        throw new RuntimeException("Could not resolve download: " + artifact);
                    }
                    files.add(lib);
                }
            }
            if (output.exists()) {
                output.delete();
            }
            output.getParentFile().mkdirs();
            output.createNewFile();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));
            for (File file : files) {
                writer.println("-e=" + file.getAbsolutePath());
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return output;
    }
}

