/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.function;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.mcp.function.ExecuteFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.gradle.api.Project;

class AccessTransformerFunction
extends ExecuteFunction {
    private List<File> files;
    private String transformers;

    public AccessTransformerFunction(Project mcp, List<File> files) {
        super(AccessTransformerFunction.getJar(mcp), new String[0], AccessTransformerFunction.getArguments(files), new HashMap<String, String>());
        this.loadData(Collections.emptyMap());
        this.files = files;
    }

    private static File getJar(Project mcp) {
        return MavenArtifactDownloader.gradle(mcp, "net.minecraftforge:accesstransformers:3.0.+:fatjar", false);
    }

    private static String[] getArguments(List<File> files) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--inJar");
        args.add("{input}");
        args.add("--outJar");
        args.add("{output}");
        files.forEach(f -> {
            args.add("--atFile");
            args.add(f.getAbsolutePath());
        });
        return args.toArray(new String[args.size()]);
    }

    @Override
    public File execute(MCPEnvironment env) throws IOException, InterruptedException, ExecutionException {
        if (this.transformers != null) {
            File tmp = File.createTempFile("FG_ats_", ".cfg");
            tmp.deleteOnExit();
            Files.write(tmp.toPath(), this.transformers.getBytes(), new OpenOption[0]);
            ArrayList<String> args = new ArrayList<String>(Arrays.asList(this.runArgs));
            args.add("--atFile");
            args.add(tmp.getAbsolutePath());
            this.runArgs = args.toArray(new String[args.size()]);
        }
        return super.execute(env);
    }

    public void addTransformer(String data) {
        this.transformers = this.transformers == null ? data : this.transformers + "\n#============================================================\n" + data;
    }

    @Override
    protected void addInputs(HashStore cache) {
        cache.add(this.files);
        if (this.transformers != null) {
            cache.add("transformers", this.transformers);
        }
    }

    @Override
    public void addInputs(HashStore cache, String prefix) {
        cache.add(prefix + "args", String.join((CharSequence)" ", this.runArgs));
        cache.add(prefix + "jvmargs", String.join((CharSequence)" ", this.runArgs));
        cache.add(this.files);
        if (this.transformers != null) {
            cache.add(prefix + "transformers", this.transformers);
        }
        try {
            cache.add(prefix + "jar", this.jar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addInputs(cache);
    }
}

