/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.util;

import java.io.File;
import java.util.Map;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.srgutils.MinecraftVersion;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class MCPEnvironment {
    private final MCPRuntime runtime;
    public final Project project;
    public final String side;
    public Logger logger;
    private final MinecraftVersion mcVersion;
    private final JavaLanguageVersion javaVersion;

    public MCPEnvironment(MCPRuntime runtime, String mcVersion, int javaVersion, String side) {
        this.runtime = runtime;
        this.project = runtime.project;
        this.side = side;
        this.mcVersion = MinecraftVersion.from((String)mcVersion);
        this.javaVersion = JavaLanguageVersion.of((int)javaVersion);
    }

    public Map<String, Object> getArguments() {
        return this.runtime.currentStep.arguments;
    }

    public File getWorkingDir() {
        return this.runtime.currentStep.workingDirectory;
    }

    public File getConfigZip() {
        return this.runtime.zipFile;
    }

    public File getFile(String name) {
        File file = new File(name);
        if (file.getAbsolutePath().equals(name)) {
            return file;
        }
        if (name.startsWith("/")) {
            return new File(this.runtime.mcpDirectory, name);
        }
        return new File(this.getWorkingDir(), name);
    }

    public File getStepOutput(String name) {
        MCPRuntime.Step step = this.runtime.steps.get(name);
        if (step == null) {
            throw new IllegalArgumentException("Could not find a step named " + name);
        }
        if (step.output == null) {
            throw new IllegalArgumentException("Attempted to get the output of an unexecuted step: " + name);
        }
        return step.output;
    }

    public MinecraftVersion getMinecraftVersion() {
        return this.mcVersion;
    }

    public JavaLanguageVersion getJavaVersion() {
        return this.javaVersion;
    }
}

