/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import com.google.common.collect.Maps;
import de.siegmar.fastcsv.writer.CsvWriter;
import de.siegmar.fastcsv.writer.LineDelimiter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import net.minecraftforge.artifactural.api.repository.ArtifactProvider;
import net.minecraftforge.artifactural.api.repository.Repository;
import net.minecraftforge.artifactural.base.repository.ArtifactProviderBuilder;
import net.minecraftforge.artifactural.base.repository.SimpleRepository;
import net.minecraftforge.artifactural.gradle.GradleRepositoryAdapter;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.DownloadUtils;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.ManifestJson;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.gradle.mcp.util.MCPWrapper;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.logging.Logger;

public class MCPRepo
extends BaseRepo {
    private static MCPRepo INSTANCE = null;
    private static final String GROUP_MINECRAFT = "net.minecraft";
    private static final String NAMES_MINECRAFT = "^(client|server|joined|mappings_[a-z_]+)$";
    private static final String GROUP_MCP = "de.oceanlabs.mcp";
    private static final String NAMES_MCP = "^(mcp_config)$";
    private static final String STEP_MERGE = "merge";
    private static final String STEP_RENAME = "rename";
    public static final String MAPPING_DEP = "net.minecraft:mappings_{CHANNEL}:{VERSION}@zip";
    private final Project project;
    private final Repository repo;
    private final Map<String, MCPWrapper> wrappers = Maps.newHashMap();
    private final Map<String, McpNames> mapCache = new HashMap<String, McpNames>();

    public static String getMappingDep(String channel, String version) {
        return MAPPING_DEP.replace("{CHANNEL}", channel).replace("{VERSION}", version);
    }

    private MCPRepo(Project project, File cache, Logger log) {
        super(cache, log);
        this.project = project;
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).provide((ArtifactProvider)this));
    }

    private static MCPRepo getInstance(Project project) {
        if (INSTANCE == null) {
            INSTANCE = new MCPRepo(project, Utils.getCache(project, "mcp_repo"), project.getLogger());
        }
        return INSTANCE;
    }

    public static void attach(Project project) {
        MCPRepo instance = MCPRepo.getInstance(project);
        GradleRepositoryAdapter.add((RepositoryHandler)project.getRepositories(), (String)"MCP_DYNAMIC", (File)instance.getCacheRoot(), (Repository)instance.repo);
    }

    public static ArtifactProvider<ArtifactIdentifier> create(Project project) {
        return MCPRepo.getInstance(project);
    }

    private File cacheMC(String side, String version, @Nullable String classifier, String ext) {
        if (classifier != null) {
            return this.cache("net", "minecraft", side, version, side + '-' + version + '-' + classifier + '.' + ext);
        }
        return this.cache("net", "minecraft", side, version, side + '-' + version + '.' + ext);
    }

    private File cacheMCP(String version, @Nullable String classifier, String ext) {
        if (classifier != null) {
            return this.cache("de", "oceanlabs", "mcp", "mcp_config", version, "mcp_config-" + version + '-' + classifier + '.' + ext);
        }
        return this.cache("de", "oceanlabs", "mcp", "mcp_config", version, "mcp_config-" + version + '.' + ext);
    }

    private File cacheMCP(String version) {
        return this.cache("de", "oceanlabs", "mcp", "mcp_config", version);
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String name = artifact.getName();
        String group = artifact.getGroup();
        if (group.equals(GROUP_MCP)) {
            if (!name.matches(NAMES_MCP)) {
                return null;
            }
        } else if (group.equals(GROUP_MINECRAFT)) {
            if (!name.matches(NAMES_MINECRAFT)) {
                return null;
            }
        } else {
            return null;
        }
        String version = artifact.getVersion();
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + name + ":" + version + ":" + classifier + "@" + ext);
        if (group.equals(GROUP_MINECRAFT)) {
            if (name.startsWith("mappings_")) {
                if ("zip".equals(ext)) {
                    return this.findNames(name.substring(9) + '_' + version);
                }
                if ("pom".equals(ext)) {
                    return this.findEmptyPom(name, version);
                }
            } else {
                if ("pom".equals(ext)) {
                    return this.findPom(name, version);
                }
                switch (classifier) {
                    case "": {
                        return this.findRaw(name, version);
                    }
                    case "srg": {
                        return this.findSrg(name, version);
                    }
                    case "extra": {
                        return this.findExtra(name, version);
                    }
                }
            }
        } else if (group.equals(GROUP_MCP)) {
            // empty if block
        }
        return null;
    }

    private HashStore commonHash(File mcp) {
        return new HashStore(this.getCacheRoot()).add("mcp", mcp);
    }

    @Nullable
    private File getMCP(String version) {
        return MavenArtifactDownloader.manual(this.project, "de.oceanlabs.mcp:mcp_config:" + version + "@zip", false);
    }

    @Nullable
    private File findVersion(String version) throws IOException {
        File manifest = this.cache("versions", "manifest.json");
        if (!DownloadUtils.downloadEtag(new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json"), manifest, this.project.getGradle().getStartParameter().isOffline())) {
            return null;
        }
        Utils.updateHash(manifest);
        File json = this.cache("versions", version, "version.json");
        URL url = Utils.loadJson(manifest, ManifestJson.class).getUrl(version);
        if (url == null) {
            throw new RuntimeException("Missing version from manifest: " + version);
        }
        if (!DownloadUtils.downloadEtag(url, json, this.project.getGradle().getStartParameter().isOffline())) {
            return null;
        }
        Utils.updateHash(json);
        return json;
    }

    @Nullable
    private File findPom(String side, String version) throws IOException {
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File pom = this.cacheMC(side, version, null, "pom");
        this.debug("    Finding pom: " + pom);
        HashStore cache = this.commonHash(mcp).load(this.cacheMC(side, version, null, "pom.input"));
        File json = null;
        if (!"server".equals(side)) {
            json = this.findVersion(MinecraftRepo.getMCVersion(version));
            if (json == null) {
                this.project.getLogger().lifecycle("Could not make Minecraft POM. Missing version json");
                return null;
            }
            cache.add("json", json);
        }
        if (!cache.isSame() || !pom.exists()) {
            POMBuilder builder = new POMBuilder(GROUP_MINECRAFT, side, version);
            if (!"server".equals(side)) {
                VersionJson meta = Utils.loadJson(json, VersionJson.class);
                for (VersionJson.Library lib : meta.libraries) {
                    if (!lib.isAllowed()) continue;
                    if (lib.downloads.artifact != null) {
                        builder.dependencies().add(lib.name, "compile");
                    }
                    if (lib.downloads.classifiers == null) continue;
                    if (lib.downloads.classifiers.containsKey("test")) {
                        builder.dependencies().add(lib.name, "test").withClassifier("test");
                    }
                    if (lib.natives == null || !lib.natives.containsKey(MinecraftRepo.CURRENT_OS) || lib.getArtifact().getName().contains("java-objc-bridge")) continue;
                    builder.dependencies().add(lib.name, "runtime").withClassifier(lib.natives.get(MinecraftRepo.CURRENT_OS));
                }
                builder.dependencies().add("net.minecraft:client:" + version, "compile").withClassifier("extra");
            } else {
                builder.dependencies().add("net.minecraft:server:" + version, "compile").withClassifier("extra");
            }
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            wrapper.getConfig().getLibraries(side).forEach(e -> builder.dependencies().add((String)e, "compile"));
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    @Nullable
    private File findRaw(String side, String version) throws IOException {
        if (!"joined".equals(side)) {
            return null;
        }
        return this.findStepOutput(side, version, null, "jar", STEP_MERGE);
    }

    @Nullable
    private File findSrg(String side, String version) throws IOException {
        return this.findStepOutput(side, version, "srg", "jar", STEP_RENAME);
    }

    @Nullable
    private File findStepOutput(String side, String version, @Nullable String classifier, String ext, String step) throws IOException {
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File raw = this.cacheMC(side, version, classifier, ext);
        this.debug("  Finding " + step + ": " + raw);
        HashStore cache = this.commonHash(mcp).load(this.cacheMC(side, version, classifier, ext + ".input"));
        if (!cache.isSame() || !raw.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            MCPRuntime runtime = wrapper.getRuntime(this.project, side);
            try {
                File output = runtime.execute(this.log, step);
                FileUtils.copyFile((File)output, (File)raw);
                cache.save();
                Utils.updateHash(raw, HashFunction.SHA1);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.lifecycle(e.getMessage());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return raw;
    }

    private synchronized MCPWrapper getWrapper(String version, File data) throws IOException {
        String hash = HashFunction.SHA1.hash(data);
        MCPWrapper ret = this.wrappers.get(version);
        if (ret == null || !hash.equals(ret.getHash())) {
            ret = new MCPWrapper(hash, data, this.cacheMCP(version));
            this.wrappers.put(version, ret);
        }
        return ret;
    }

    @Nullable
    private File findRenames(String classifier, IMappingFile.Format format, String version, boolean toObf) throws IOException {
        String ext = format.name().toLowerCase();
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File file = this.cacheMCP(version, classifier, ext);
        this.debug("    Finding Renames: " + file);
        HashStore cache = this.commonHash(mcp).load(this.cacheMCP(version, classifier, ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            byte[] data = wrapper.getData("mappings");
            IMappingFile obf_to_srg = IMappingFile.load((InputStream)new ByteArrayInputStream(data));
            obf_to_srg.write(file.toPath(), format, toObf);
            cache.save();
            Utils.updateHash(file, HashFunction.SHA1);
        }
        return file;
    }

    @Nullable
    private File findNames(String mapping) throws IOException {
        int idx = mapping.lastIndexOf(95);
        if (idx == -1) {
            return null;
        }
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        if ("official".equals(channel)) {
            return this.findOfficialMapping(version);
        }
        if ("snapshot".equals(channel) || "snapshot_nodoc".equals(channel) || "stable".equals(channel) || "stable_nodoc".equals(channel)) {
            String desc = "de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip";
            this.debug("    Mapping: " + desc);
            return MavenArtifactDownloader.manual(this.project, desc, false);
        }
        throw new IllegalArgumentException("Unknown mapping provider: " + mapping);
    }

    private McpNames loadMCPNames(String name, File data) throws IOException {
        McpNames map = this.mapCache.get(name);
        String hash = HashFunction.SHA1.hash(data);
        if (map == null || !hash.equals(map.hash)) {
            map = McpNames.load(data);
            this.mapCache.put(name, map);
        }
        return map;
    }

    @Nullable
    private File findRenames(String classifier, IMappingFile.Format format, String version, String mapping, boolean obf, boolean reverse) throws IOException {
        String ext = format.name().toLowerCase();
        File names = this.findNames(version);
        File mcp = this.getMCP(version);
        if (mcp == null || names == null) {
            return null;
        }
        File file = this.cacheMCP(version, classifier, ext);
        this.debug("    Finding Renames: " + file);
        HashStore cache = this.commonHash(mcp).load(this.cacheMCP(version, classifier, ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            byte[] data = wrapper.getData("mappings");
            IMappingFile input = IMappingFile.load((InputStream)new ByteArrayInputStream(data));
            if (!obf) {
                input = input.reverse().chain(input);
            }
            final McpNames map = this.loadMCPNames(mapping, names);
            IMappingFile ret = input.rename(new IRenamer(){

                public String rename(IMappingFile.IField value) {
                    return map.rename(value.getMapped());
                }

                public String rename(IMappingFile.IMethod value) {
                    return map.rename(value.getMapped());
                }
            });
            ret.write(file.toPath(), format, reverse);
            cache.save();
            Utils.updateHash(file, HashFunction.SHA1);
        }
        return file;
    }

    @Nullable
    private File findExtra(String side, String version) throws IOException {
        File raw = this.findRaw(side, version);
        File mcp = this.getMCP(version);
        if (raw == null || mcp == null) {
            return null;
        }
        File extra = this.cacheMC(side, version, "extra", "jar");
        HashStore cache = this.commonHash(mcp).load(this.cacheMC(side, version, "extra", "jar.input")).add("raw", raw).add("mcp", mcp).add("codever", "1");
        if (!cache.isSame() || !extra.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            byte[] data = wrapper.getData("mappings");
            MinecraftRepo.splitJar(raw, new ByteArrayInputStream(data), extra, false, true);
            cache.save();
        }
        return extra;
    }

    @Nullable
    private File findOfficialMapping(String version) throws IOException {
        String mcpversion = version;
        int idx = version.lastIndexOf(45);
        if (idx != -1 && MinecraftRepo.MCP_CONFIG_VERSION.matcher(version.substring(idx + 1)).matches()) {
            version = version.substring(0, idx);
        }
        File client = MavenArtifactDownloader.generate(this.project, "net.minecraft:client:" + version + ":mappings@txt", true);
        File server = MavenArtifactDownloader.generate(this.project, "net.minecraft:server:" + version + ":mappings@txt", true);
        if (client == null || server == null) {
            throw new IllegalStateException("Could not create " + mcpversion + " official mappings due to missing ProGuard mappings.");
        }
        File tsrg = this.findRenames("obf_to_srg", IMappingFile.Format.TSRG, mcpversion, false);
        if (tsrg == null) {
            throw new IllegalStateException("Could not create " + mcpversion + " official mappings due to missing MCP's tsrg");
        }
        File mcp = this.getMCP(mcpversion);
        if (mcp == null) {
            return null;
        }
        File mappings = this.cacheMC("mapping", mcpversion, "mapping", "zip");
        HashStore cache = this.commonHash(mcp).load(this.cacheMC("mapping", mcpversion, "mapping", "zip.input")).add("pg_client", client).add("pg_server", server).add("tsrg", tsrg).add("codever", "1");
        if (!cache.isSame() || !mappings.exists()) {
            String sname;
            String cname;
            String name;
            IMappingFile.IClass obf;
            IMappingFile pg_client = IMappingFile.load((File)client);
            IMappingFile pg_server = IMappingFile.load((File)server);
            IMappingFile srg = IMappingFile.load((File)tsrg);
            TreeMap<String, String> cfields = new TreeMap<String, String>();
            TreeMap<String, String> sfields = new TreeMap<String, String>();
            TreeMap<String, String> cmethods = new TreeMap<String, String>();
            TreeMap<String, String> smethods = new TreeMap<String, String>();
            for (IMappingFile.IClass cls : pg_client.getClasses()) {
                obf = srg.getClass(cls.getMapped());
                if (obf == null) continue;
                for (IMappingFile.IField fld : cls.getFields()) {
                    name = obf.remapField(fld.getMapped());
                    if (!name.startsWith("field_") && !name.startsWith("f_")) continue;
                    cfields.put(name, fld.getOriginal());
                }
                for (IMappingFile.IMethod mtd : cls.getMethods()) {
                    name = obf.remapMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                    if (!name.startsWith("func_") && !name.startsWith("m_")) continue;
                    cmethods.put(name, mtd.getOriginal());
                }
            }
            for (IMappingFile.IClass cls : pg_server.getClasses()) {
                obf = srg.getClass(cls.getMapped());
                if (obf == null) continue;
                for (IMappingFile.IField fld : cls.getFields()) {
                    name = obf.remapField(fld.getMapped());
                    if (!name.startsWith("field_") && !name.startsWith("f_")) continue;
                    sfields.put(name, fld.getOriginal());
                }
                for (IMappingFile.IMethod mtd : cls.getMethods()) {
                    name = obf.remapMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                    if (!name.startsWith("func_") && !name.startsWith("m_")) continue;
                    smethods.put(name, mtd.getOriginal());
                }
            }
            String[] header = new String[]{"searge", "name", "side", "desc"};
            ArrayList<String[]> fields = new ArrayList<String[]>();
            ArrayList<String[]> methods = new ArrayList<String[]>();
            fields.add(header);
            methods.add(header);
            for (String name2 : cfields.keySet()) {
                cname = (String)cfields.get(name2);
                if (cname.equals(sname = (String)sfields.get(name2))) {
                    fields.add(new String[]{name2, cname, "2", ""});
                    sfields.remove(name2);
                    continue;
                }
                fields.add(new String[]{name2, cname, "0", ""});
            }
            for (String name2 : cmethods.keySet()) {
                cname = (String)cmethods.get(name2);
                if (cname.equals(sname = (String)smethods.get(name2))) {
                    methods.add(new String[]{name2, cname, "2", ""});
                    smethods.remove(name2);
                    continue;
                }
                methods.add(new String[]{name2, cname, "0", ""});
            }
            sfields.forEach((k, v) -> fields.add(new String[]{k, v, "1", ""}));
            smethods.forEach((k, v) -> methods.add(new String[]{k, v, "1", ""}));
            if (!mappings.getParentFile().exists()) {
                mappings.getParentFile().mkdirs();
            }
            try (FileOutputStream fos = new FileOutputStream(mappings);
                 ZipOutputStream out = new ZipOutputStream(fos);){
                out.putNextEntry(Utils.getStableEntry("fields.csv"));
                try (CsvWriter writer = CsvWriter.builder().lineDelimiter(LineDelimiter.LF).build((Writer)new UncloseableOutputStreamWriter(out));){
                    fields.forEach(arg_0 -> ((CsvWriter)writer).writeRow(arg_0));
                }
                out.closeEntry();
                out.putNextEntry(Utils.getStableEntry("methods.csv"));
                writer = CsvWriter.builder().lineDelimiter(LineDelimiter.LF).build((Writer)new UncloseableOutputStreamWriter(out));
                var25_29 = null;
                try {
                    methods.forEach(arg_0 -> ((CsvWriter)writer).writeRow(arg_0));
                }
                catch (Throwable throwable) {
                    var25_29 = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (var25_29 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                var25_29.addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
                out.closeEntry();
            }
            cache.save();
            Utils.updateHash(mappings, HashFunction.SHA1);
        }
        return mappings;
    }

    @Nullable
    private File findEmptyPom(String side, String version) throws IOException {
        File pom = this.cacheMC(side, version, null, "pom");
        this.debug("    Finding pom: " + pom);
        HashStore cache = new HashStore(this.getCacheRoot()).load(this.cacheMC(side, version, null, "pom.input"));
        if (!cache.isSame() || !pom.exists()) {
            String ret = new POMBuilder(GROUP_MINECRAFT, side, version).tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private static class UncloseableOutputStreamWriter
    extends OutputStreamWriter {
        public UncloseableOutputStreamWriter(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            super.flush();
        }
    }
}

