/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.runs.EclipseRunGenerator;
import net.minecraftforge.gradle.common.util.runs.RunConfigGenerator;
import org.gradle.api.Project;

public class VSCodeRunGenerator
extends RunConfigGenerator.JsonConfigurationBuilder {
    @Override
    @Nonnull
    protected JsonObject createRunConfiguration(@Nonnull Project project, @Nonnull RunConfig runConfig, List<String> additionalClientArgs) {
        Map<String, String> updatedTokens = VSCodeRunGenerator.configureTokens(runConfig, VSCodeRunGenerator.createRuntimeClassPathList(project), this.mapModClassesToVSCode(project, runConfig));
        JsonObject config = new JsonObject();
        config.addProperty("type", "java");
        config.addProperty("name", runConfig.getTaskName());
        config.addProperty("request", "launch");
        config.addProperty("mainClass", runConfig.getMain());
        config.addProperty("projectName", project.getName());
        config.addProperty("cwd", VSCodeRunGenerator.replaceRootDirBy(project, runConfig.getWorkingDirectory(), "${workspaceFolder}"));
        config.addProperty("vmArgs", VSCodeRunGenerator.getJvmArgs(runConfig, additionalClientArgs, updatedTokens));
        config.addProperty("args", VSCodeRunGenerator.getArgs(runConfig, updatedTokens));
        JsonObject env = new JsonObject();
        runConfig.getEnvironment().forEach((key, value) -> {
            value = runConfig.replace(updatedTokens, (String)value);
            if (key.equals("nativesDirectory")) {
                value = VSCodeRunGenerator.replaceRootDirBy(project, value, "${workspaceFolder}");
            }
            env.addProperty(key, value);
        });
        config.add("env", (JsonElement)env);
        return config;
    }

    private Stream<String> mapModClassesToVSCode(@Nonnull Project project, @Nonnull RunConfig runConfig) {
        return EclipseRunGenerator.mapModClassesToEclipse(project, runConfig).map(value -> VSCodeRunGenerator.replaceRootDirBy(project, value, "${workspaceFolder}"));
    }
}

