/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util.runs;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.minecraftforge.gradle.common.util.MinecraftExtension;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.runs.EclipseRunGenerator;
import net.minecraftforge.gradle.common.util.runs.IntellijRunGenerator;
import net.minecraftforge.gradle.common.util.runs.VSCodeRunGenerator;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class RunConfigGenerator {
    public abstract void createRunConfiguration(@Nonnull MinecraftExtension var1, @Nonnull File var2, @Nonnull Project var3, List<String> var4);

    public static void createIDEGenRunsTasks(@Nonnull MinecraftExtension minecraft, @Nonnull TaskProvider<Task> prepareRuns, @Nonnull TaskProvider<Task> makeSourceDirs, List<String> additionalClientArgs) {
        Project project = minecraft.getProject();
        ImmutableMap ideConfigurationGenerators = ImmutableMap.builder().put((Object)"genIntellijRuns", (Object)ImmutableTriple.of(Collections.singletonList(prepareRuns.get()), (Object)new File(project.getRootProject().getRootDir(), ".idea/runConfigurations"), () -> new IntellijRunGenerator(project.getRootProject()))).put((Object)"genEclipseRuns", (Object)ImmutableTriple.of((Object)ImmutableList.of((Object)prepareRuns.get(), (Object)makeSourceDirs.get()), (Object)project.getProjectDir(), EclipseRunGenerator::new)).put((Object)"genVSCodeRuns", (Object)ImmutableTriple.of((Object)ImmutableList.of((Object)prepareRuns.get(), (Object)makeSourceDirs.get()), (Object)new File(project.getProjectDir(), ".vscode"), VSCodeRunGenerator::new)).build();
        ideConfigurationGenerators.forEach((taskName, configurationGenerator) -> project.getTasks().register(taskName, Task.class, task -> {
            task.setGroup("ForgeGradle runs");
            task.dependsOn(new Object[]{configurationGenerator.getLeft()});
            task.doLast(t -> {
                File runConfigurationsDir = (File)configurationGenerator.getMiddle();
                if (!runConfigurationsDir.exists()) {
                    runConfigurationsDir.mkdirs();
                }
                ((RunConfigGenerator)((Supplier)configurationGenerator.getRight()).get()).createRunConfiguration(minecraft, runConfigurationsDir, project, additionalClientArgs);
            });
        }));
    }

    protected static void elementOption(@Nonnull Document document, @Nonnull Element parent, @Nonnull String name, @Nonnull String value) {
        Element option = document.createElement("option");
        option.setAttribute("name", name);
        option.setAttribute("value", value);
        parent.appendChild(option);
    }

    protected static void elementAttribute(@Nonnull Document document, @Nonnull Element parent, @Nonnull String attributeType, @Nonnull String key, @Nonnull String value) {
        Element attribute = document.createElement(attributeType + "Attribute");
        attribute.setAttribute("key", key);
        attribute.setAttribute("value", value);
        parent.appendChild(attribute);
    }

    protected static String replaceRootDirBy(@Nonnull Project project, String value, @Nonnull String replacement) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return value.replace(project.getRootDir().toString(), replacement);
    }

    protected static Stream<String> mapModClassesToGradle(Project project, RunConfig runConfig) {
        if (runConfig.getMods().isEmpty()) {
            List<SourceSet> sources = runConfig.getAllSources();
            return Stream.concat(sources.stream().map(source -> source.getOutput().getResourcesDir()), sources.stream().map(source -> source.getOutput().getClassesDirs().getFiles()).flatMap(Collection::stream)).map(File::getAbsolutePath);
        }
        SourceSet main = (SourceSet)((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().getByName("main");
        return runConfig.getMods().stream().map(modConfig -> (modConfig.getSources().isEmpty() ? Stream.of(main) : modConfig.getSources().stream()).flatMap(source -> Streams.concat((Stream[])new Stream[]{Stream.of(source.getOutput().getResourcesDir()), source.getOutput().getClassesDirs().getFiles().stream()})).map(File::getAbsolutePath).distinct().map(s -> modConfig.getName() + "%%" + s).collect(Collectors.joining(File.pathSeparator)));
    }

    protected static Map<String, String> configureTokens(@Nonnull RunConfig runConfig, String runtimeClassPathList, Stream<String> modClasses) {
        HashMap<String, String> tokens = new HashMap<String, String>(runConfig.getTokens());
        tokens.compute("source_roots", (key, sourceRoots) -> (sourceRoots != null ? Stream.concat(Arrays.stream(sourceRoots.split(File.pathSeparator)), modClasses) : modClasses).distinct().collect(Collectors.joining(File.pathSeparator)));
        tokens.compute("runtime_classpath", (key, runtimeclasspath) -> runtimeClassPathList);
        runConfig.getEnvironment().compute("MOD_CLASSES", (key, value) -> Strings.isNullOrEmpty((String)value) || "dummy".equals(value) ? "{source_roots}" : value);
        return tokens;
    }

    public static TaskProvider<JavaExec> createRunTask(RunConfig runConfig, Project project, TaskProvider<Task> prepareRuns, List<String> additionalClientArgs) {
        return RunConfigGenerator.createRunTask(runConfig, project, (Task)prepareRuns.get(), additionalClientArgs);
    }

    protected static String createRuntimeClassPathList(Project project) {
        return project.getConfigurations().getByName("runtimeClasspath").getFiles().stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator));
    }

    public static TaskProvider<JavaExec> createRunTask(RunConfig runConfig, Project project, Task prepareRuns, List<String> additionalClientArgs) {
        Map<String, String> updatedTokens = RunConfigGenerator.configureTokens(runConfig, RunConfigGenerator.createRuntimeClassPathList(project), RunConfigGenerator.mapModClassesToGradle(project, runConfig));
        TaskProvider prepareRun = project.getTasks().register("prepare" + Utils.capitalize(runConfig.getTaskName()), Task.class, task -> {
            task.setGroup("ForgeGradle runs");
            task.dependsOn(new Object[]{prepareRuns, runConfig.getAllSources().stream().map(SourceSet::getClassesTaskName).toArray()});
            File workDir = new File(runConfig.getWorkingDirectory());
            if (!workDir.exists()) {
                workDir.mkdirs();
            }
        });
        return project.getTasks().register(runConfig.getTaskName(), JavaExec.class, task -> {
            task.setGroup("ForgeGradle runs");
            task.dependsOn(new Object[]{prepareRun.get()});
            File workDir = new File(runConfig.getWorkingDirectory());
            if (!workDir.exists()) {
                workDir.mkdirs();
            }
            task.setWorkingDir(workDir);
            task.getMainClass().set((Object)runConfig.getMain());
            JavaToolchainService service = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
            task.getJavaLauncher().set(service.launcherFor(((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain()));
            task.args(RunConfigGenerator.getArgsStream(runConfig, updatedTokens, false).toArray());
            runConfig.getJvmArgs().forEach(arg -> task.jvmArgs(new Object[]{runConfig.replace(updatedTokens, (String)arg)}));
            if (runConfig.isClient()) {
                additionalClientArgs.forEach(arg -> task.jvmArgs(new Object[]{runConfig.replace(updatedTokens, (String)arg)}));
            }
            runConfig.getEnvironment().forEach((key, value) -> task.environment(key, (Object)runConfig.replace(updatedTokens, (String)value)));
            runConfig.getProperties().forEach((key, value) -> task.systemProperty(key, (Object)runConfig.replace(updatedTokens, (String)value)));
            runConfig.getAllSources().stream().map(SourceSet::getRuntimeClasspath).forEach(xva$0 -> task.classpath(new Object[]{xva$0}));
            if (runConfig.getForceExit()) {
                task.doLast(t -> System.exit(0));
            }
        });
    }

    protected static String fixupArg(String replace) {
        if (replace.startsWith("\"")) {
            return replace;
        }
        if (!replace.contains(" ")) {
            return replace;
        }
        return '\"' + replace + '\"';
    }

    protected static String getArgs(RunConfig runConfig, Map<String, String> updatedTokens) {
        return RunConfigGenerator.getArgsStream(runConfig, updatedTokens, true).collect(Collectors.joining(" "));
    }

    protected static Stream<String> getArgsStream(RunConfig runConfig, Map<String, String> updatedTokens, boolean wrapSpaces) {
        Stream<String> args = runConfig.getArgs().stream().map(value -> runConfig.replace(updatedTokens, (String)value));
        return wrapSpaces ? args.map(RunConfigGenerator::fixupArg) : args;
    }

    protected static String getJvmArgs(@Nonnull RunConfig runConfig, List<String> additionalClientArgs, Map<String, String> updatedTokens) {
        return RunConfigGenerator.getJvmArgsStream(runConfig, additionalClientArgs, updatedTokens).collect(Collectors.joining(" "));
    }

    private static Stream<String> getJvmArgsStream(@Nonnull RunConfig runConfig, List<String> additionalClientArgs, Map<String, String> updatedTokens) {
        Stream<String> propStream = Stream.concat(runConfig.getProperties().entrySet().stream().map(kv -> String.format("-D%s=%s", kv.getKey(), runConfig.replace(updatedTokens, (String)kv.getValue()))), runConfig.getJvmArgs().stream().map(value -> runConfig.replace(updatedTokens, (String)value))).map(RunConfigGenerator::fixupArg);
        if (runConfig.isClient()) {
            return Stream.concat(propStream, additionalClientArgs.stream());
        }
        return propStream;
    }

    static abstract class JsonConfigurationBuilder
    extends RunConfigGenerator {
        JsonConfigurationBuilder() {
        }

        @Nonnull
        protected abstract JsonObject createRunConfiguration(@Nonnull Project var1, @Nonnull RunConfig var2, List<String> var3);

        @Override
        public final void createRunConfiguration(@Nonnull MinecraftExtension minecraft, @Nonnull File runConfigurationsDir, @Nonnull Project project, List<String> additionalClientArgs) {
            JsonObject rootObject = new JsonObject();
            rootObject.addProperty("version", "0.2.0");
            JsonArray runConfigs = new JsonArray();
            minecraft.getRuns().forEach(runConfig -> runConfigs.add((JsonElement)this.createRunConfiguration(project, (RunConfig)runConfig, additionalClientArgs)));
            rootObject.add("configurations", (JsonElement)runConfigs);
            try {
                FileWriter writer = new FileWriter(new File(runConfigurationsDir, "launch.json"));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                writer.write(gson.toJson((JsonElement)rootObject));
                ((Writer)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static abstract class XMLConfigurationBuilder
    extends RunConfigGenerator {
        XMLConfigurationBuilder() {
        }

        @Nonnull
        protected abstract Map<String, Document> createRunConfiguration(@Nonnull Project var1, @Nonnull RunConfig var2, @Nonnull DocumentBuilder var3, List<String> var4);

        @Override
        public final void createRunConfiguration(@Nonnull MinecraftExtension minecraft, @Nonnull File runConfigurationsDir, @Nonnull Project project, List<String> additionalClientArgs) {
            try {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                minecraft.getRuns().forEach(runConfig -> {
                    Map<String, Document> documents = this.createRunConfiguration(project, (RunConfig)runConfig, docBuilder, additionalClientArgs);
                    documents.forEach((fileName, document) -> {
                        DOMSource source = new DOMSource((Node)document);
                        StreamResult result = new StreamResult(new File(runConfigurationsDir, (String)fileName));
                        try {
                            transformer.transform(source, result);
                        }
                        catch (TransformerException e) {
                            e.printStackTrace();
                        }
                    });
                });
            }
            catch (ParserConfigurationException | TransformerConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

