/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import de.siegmar.fastcsv.reader.NamedCsvReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.JavadocAdder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class McpNames {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern SRG_FINDER = Pattern.compile("[fF]unc_\\d+_[a-zA-Z_]+|m_\\d+_|[fF]ield_\\d+_[a-zA-Z_]+|f_\\d+_|p_\\w+_\\d+_|p_\\d+_");
    private static final Pattern METHOD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?<generic><[\\w\\W]*>\\s+)?(?<return>\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>(?:func_|m_)[0-9]+_[a-zA-Z_]+)\\(");
    private static final Pattern FIELD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*\\s+(?<name>(?:field_|f_)[0-9]+_[a-zA-Z_]+) *[=;]");
    private static final Pattern CLASS_JAVADOC_PATTERN = Pattern.compile("^(?<indent> *|\\t*)([\\w|@]*\\s)*(class|interface|@interface|enum) (?<name>[\\w]+)");
    private static final Pattern CLOSING_CURLY_BRACE = Pattern.compile("^(?<indent> *|\\t*)}");
    private static final Pattern PACKAGE_DECL = Pattern.compile("^[\\s]*package(\\s)*(?<name>[\\w|.]+);$");
    private static final Pattern LAMBDA_DECL = Pattern.compile("\\((?<args>(?:(?:, ){0,1}p_[\\w]+_\\d+_\\b)+)\\) ->");
    private final Map<String, String> names;
    private final Map<String, String> docs;
    public final String hash;

    public static McpNames load(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                NamedCsvReader reader = NamedCsvReader.builder().build((Reader)new InputStreamReader(zip.getInputStream(entry)));
                Throwable throwable = null;
                try {
                    String obf = reader.getHeader().contains("searge") ? "searge" : "param";
                    boolean hasDesc = reader.getHeader().contains("desc");
                    reader.forEach(row -> {
                        String desc;
                        String searge = row.getField(obf);
                        names.put(searge, row.getField("name"));
                        if (hasDesc && !(desc = row.getField("desc")).isEmpty()) {
                            docs.put(searge, desc);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        return new McpNames(HashFunction.SHA1.hash(data), names, docs);
    }

    private McpNames(String hash, Map<String, String> names, Map<String, String> docs) {
        this.hash = hash;
        this.names = names;
        this.docs = docs;
    }

    public String rename(InputStream stream, boolean javadocs) throws IOException {
        return this.rename(stream, javadocs, true, StandardCharsets.UTF_8);
    }

    public String rename(InputStream stream, boolean javadocs, boolean lambdas) throws IOException {
        return this.rename(stream, javadocs, lambdas, StandardCharsets.UTF_8);
    }

    public String rename(InputStream stream, boolean javadocs, boolean lambdas, Charset sourceFileCharset) throws IOException {
        Matcher m;
        String data = IOUtils.toString((InputStream)stream, (Charset)sourceFileCharset);
        List input = IOUtils.readLines((Reader)new StringReader(data));
        if (data.charAt(data.length() - 1) == '\r' || data.charAt(data.length() - 1) == '\n') {
            input.add("");
        }
        ArrayList<String> lines = new ArrayList<String>();
        LinkedList<Pair<String, Integer>> innerClasses = new LinkedList<Pair<String, Integer>>();
        String _package = "";
        HashSet<String> blacklist = null;
        if (!lambdas) {
            blacklist = new HashSet<String>();
            for (String line : input) {
                m = LAMBDA_DECL.matcher(line);
                if (!m.find()) continue;
                blacklist.addAll(Arrays.asList(m.group("args").split(", ")));
            }
        }
        for (String line : input) {
            m = PACKAGE_DECL.matcher(line);
            if (m.find()) {
                _package = m.group("name") + ".";
            }
            if (javadocs && !this.injectJavadoc(lines, line, _package, innerClasses)) {
                javadocs = false;
            }
            lines.add(this.replaceInLine(line, blacklist));
        }
        return String.join((CharSequence)NEWLINE, lines);
    }

    public String rename(String entry) {
        return this.names.getOrDefault(entry, entry);
    }

    private boolean injectJavadoc(List<String> lines, String line, String _package, Deque<Pair<String, Integer>> innerClasses) {
        Matcher matcher = METHOD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String javadoc = this.docs.get(matcher.group("name"));
            if (javadoc != null) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = FIELD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String javadoc = this.docs.get(matcher.group("name"));
            if (javadoc != null) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, false));
            }
            return true;
        }
        matcher = CLASS_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String currentClass = (innerClasses.isEmpty() ? _package : (String)innerClasses.peek().getLeft() + "$") + matcher.group("name");
            innerClasses.push((Pair<String, Integer>)Pair.of((Object)currentClass, (Object)matcher.group("indent").length()));
            String javadoc = this.docs.get(currentClass);
            if (javadoc != null) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, true));
            }
            return true;
        }
        matcher = CLOSING_CURLY_BRACE.matcher(line);
        if (matcher.find() && !innerClasses.isEmpty()) {
            int len = matcher.group("indent").length();
            if (len == (Integer)innerClasses.peek().getRight()) {
                innerClasses.pop();
            } else if (len < (Integer)innerClasses.peek().getRight()) {
                System.err.println("Failed to properly track class blocks around class " + (String)innerClasses.peek().getLeft() + ":" + (lines.size() + 1));
                return false;
            }
        }
        return true;
    }

    private static void insertAboveAnnotations(List<String> list, String line) {
        int back = 0;
        while (list.get(list.size() - 1 - back).trim().startsWith("@")) {
            ++back;
        }
        list.add(list.size() - back, line);
    }

    private String getMapped(String srg, @Nullable Set<String> blacklist) {
        boolean cap;
        if (blacklist != null && blacklist.contains(srg)) {
            return srg;
        }
        boolean bl = cap = srg.charAt(0) == 'F';
        if (cap) {
            srg = 'f' + srg.substring(1);
        }
        String ret = this.names.getOrDefault(srg, srg);
        if (cap) {
            ret = ret.substring(0, 1).toUpperCase(Locale.ENGLISH) + ret.substring(1);
        }
        return ret;
    }

    private String replaceInLine(String line, @Nullable Set<String> blacklist) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG_FINDER.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement(this.getMapped(matcher.group(), blacklist)));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

