/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.tasks;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.srgutils.IMappingFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ReobfuscateJar
extends JarExec {
    private boolean keepPackages = false;
    private boolean keepData = false;
    private final Provider<RegularFile> outputTemp = this.workDir.map(d -> d.file("output_temp.jar"));

    public ReobfuscateJar() {
        this.getTool().set((Object)"net.md-5:SpecialSource:1.10.0:shaded");
        this.getArgs().addAll((Object[])new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{srg}", "--live"});
        this.getOutput().convention(this.workDir.map(d -> d.file("output.jar")));
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        super.apply();
        try (BufferedOutputStream log = new BufferedOutputStream(new FileOutputStream(((RegularFile)this.logFile.get()).getAsFile()));){
            HashSet<String> packages = new HashSet<String>();
            IMappingFile srgMappings = IMappingFile.load((File)((RegularFile)this.getSrg().get()).getAsFile());
            for (IMappingFile.IClass srgClass : srgMappings.getClasses()) {
                String named = srgClass.getOriginal();
                int idx = named.lastIndexOf(47);
                if (idx == -1) continue;
                packages.add(named.substring(0, idx + 1) + "package-info.class");
            }
            try (ZipFile zin = new ZipFile(((RegularFile)this.outputTemp.get()).getAsFile());
                 ZipOutputStream out = new ZipOutputStream(new FileOutputStream(((RegularFile)this.getOutput().get()).getAsFile()));){
                Enumeration<? extends ZipEntry> enu = zin.entries();
                while (enu.hasMoreElements()) {
                    boolean filter;
                    ZipEntry entry = enu.nextElement();
                    boolean bl = filter = entry.isDirectory() || entry.getName().startsWith("mcp/");
                    if (!this.keepPackages) {
                        filter |= packages.contains(entry.getName());
                    }
                    if (!this.keepData) {
                        filter |= !entry.getName().endsWith(".class");
                    }
                    if (filter) {
                        ((OutputStream)log).write(("Filtered: " + entry.getName() + '\n').getBytes(StandardCharsets.UTF_8));
                        continue;
                    }
                    out.putNextEntry(entry);
                    IOUtils.copy((InputStream)zin.getInputStream(entry), (OutputStream)out);
                    out.closeEntry();
                }
            }
            ((RegularFile)this.outputTemp.get()).getAsFile().delete();
        }
    }

    @Override
    protected List<String> filterArgs(List<String> args) {
        return this.replaceArgs(args, (Map<String, Object>)ImmutableMap.of((Object)"{input}", (Object)((RegularFile)this.getInput().get()).getAsFile(), (Object)"{output}", (Object)((RegularFile)this.outputTemp.get()).getAsFile(), (Object)"{srg}", (Object)((RegularFile)this.getSrg().get()).getAsFile()), null);
    }

    @InputFile
    public abstract RegularFileProperty getInput();

    @InputFile
    public abstract RegularFileProperty getSrg();

    @OutputFile
    public abstract RegularFileProperty getOutput();

    @Input
    public boolean getKeepPackages() {
        return this.keepPackages;
    }

    public void keepPackages() {
        this.keepPackages = true;
    }

    public void filterPackages() {
        this.keepPackages = false;
    }

    @Input
    public boolean getKeepData() {
        return this.keepData;
    }

    public void keepData() {
        this.keepData = true;
    }

    public void filterData() {
        this.keepData = false;
    }
}

