/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import codechicken.diffpatch.util.PatchMode;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.gradle.common.tasks.ApplyMappings;
import net.minecraftforge.gradle.common.tasks.ApplyRangeMap;
import net.minecraftforge.gradle.common.tasks.DownloadAssets;
import net.minecraftforge.gradle.common.tasks.DownloadMCMeta;
import net.minecraftforge.gradle.common.tasks.DynamicJarExec;
import net.minecraftforge.gradle.common.tasks.ExtractExistingFiles;
import net.minecraftforge.gradle.common.tasks.ExtractMCPData;
import net.minecraftforge.gradle.common.tasks.ExtractNatives;
import net.minecraftforge.gradle.common.tasks.ExtractRangeMap;
import net.minecraftforge.gradle.common.tasks.ExtractZip;
import net.minecraftforge.gradle.common.tasks.JarExec;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.EnvironmentChecks;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.MojangLicenseHelper;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.mcp.MCPPlugin;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.function.MCPFunctionFactory;
import net.minecraftforge.gradle.mcp.tasks.DownloadMCPConfig;
import net.minecraftforge.gradle.mcp.tasks.DownloadMCPMappings;
import net.minecraftforge.gradle.mcp.tasks.GenerateSRG;
import net.minecraftforge.gradle.mcp.tasks.SetupMCP;
import net.minecraftforge.gradle.patcher.PatcherExtension;
import net.minecraftforge.gradle.patcher.tasks.ApplyPatches;
import net.minecraftforge.gradle.patcher.tasks.BakePatches;
import net.minecraftforge.gradle.patcher.tasks.CreateExc;
import net.minecraftforge.gradle.patcher.tasks.CreateFakeSASPatches;
import net.minecraftforge.gradle.patcher.tasks.FilterNewJar;
import net.minecraftforge.gradle.patcher.tasks.GenerateBinPatches;
import net.minecraftforge.gradle.patcher.tasks.GeneratePatches;
import net.minecraftforge.gradle.patcher.tasks.GenerateUserdevConfig;
import net.minecraftforge.gradle.patcher.tasks.ReobfuscateJar;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.api.tasks.compile.JavaCompile;

public class PatcherPlugin
implements Plugin<Project> {
    private static final String MC_DEP_CONFIG = "minecraftImplementation";

    public void apply(@Nonnull Project project) {
        String updateChannel;
        String updateVersion;
        EnvironmentChecks.checkEnvironment(project);
        PatcherExtension extension = (PatcherExtension)((Object)project.getExtensions().create(PatcherExtension.class, "patcher", PatcherExtension.class, new Object[]{project}));
        project.getPluginManager().apply(JavaPlugin.class);
        JavaPluginExtension javaConv = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        Configuration mcImplementation = (Configuration)project.getConfigurations().maybeCreate(MC_DEP_CONFIG);
        mcImplementation.setCanBeResolved(true);
        project.getConfigurations().named("implementation").configure(c -> c.extendsFrom(new Configuration[]{mcImplementation}));
        TaskContainer tasks = project.getTasks();
        TaskProvider jarTask = tasks.named("jar", Jar.class);
        TaskProvider javaCompileTask = tasks.named("compileJava", JavaCompile.class);
        NamedDomainObjectProvider mainSource = javaConv.getSourceSets().named("main");
        TaskProvider dlMappingsConfig = tasks.register("downloadMappings", DownloadMCPMappings.class);
        TaskProvider dlMCMetaConfig = tasks.register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = tasks.register("extractNatives", ExtractNatives.class);
        TaskProvider applyPatches = tasks.register("applyPatches", ApplyPatches.class);
        TaskProvider toMCPConfig = tasks.register("srg2mcp", ApplyMappings.class);
        TaskProvider extractMapped = tasks.register("extractMapped", ExtractZip.class);
        TaskProvider createMcp2Srg = tasks.register("createMcp2Srg", GenerateSRG.class);
        TaskProvider createMcp2Obf = tasks.register("createMcp2Obf", GenerateSRG.class);
        TaskProvider createSrg2Mcp = tasks.register("createSrg2Mcp", GenerateSRG.class);
        TaskProvider createExc = tasks.register("createExc", CreateExc.class);
        TaskProvider extractRangeConfig = tasks.register("extractRangeMap", ExtractRangeMap.class);
        TaskProvider applyRangeConfig = tasks.register("applyRangeMap", ApplyRangeMap.class);
        TaskProvider applyRangeBaseConfig = tasks.register("applyRangeMapBase", ApplyRangeMap.class);
        TaskProvider genPatches = tasks.register("genPatches", GeneratePatches.class);
        TaskProvider bakePatches = tasks.register("bakePatches", BakePatches.class);
        TaskProvider downloadAssets = tasks.register("downloadAssets", DownloadAssets.class);
        TaskProvider reobfJar = tasks.register("reobfJar", ReobfuscateJar.class);
        TaskProvider genJoinedBinPatches = tasks.register("genJoinedBinPatches", GenerateBinPatches.class);
        TaskProvider genClientBinPatches = tasks.register("genClientBinPatches", GenerateBinPatches.class);
        TaskProvider genServerBinPatches = tasks.register("genServerBinPatches", GenerateBinPatches.class);
        TaskProvider genBinPatches = tasks.register("genBinPatches", DefaultTask.class);
        TaskProvider filterNew = tasks.register("filterJarNew", FilterNewJar.class);
        TaskProvider sourcesJar = tasks.register("sourcesJar", Jar.class);
        TaskProvider universalJar = tasks.register("universalJar", Jar.class);
        TaskProvider userdevJar = tasks.register("userdevJar", Jar.class);
        TaskProvider userdevConfig = tasks.register("userdevConfig", GenerateUserdevConfig.class, new Object[]{project});
        TaskProvider release = tasks.register("release", DefaultTask.class);
        TaskProvider hideLicense = tasks.register("hideOfficialWarningUntilChanged", DefaultTask.class);
        TaskProvider showLicense = tasks.register("reshowOfficialWarning", DefaultTask.class);
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://maven.minecraftforge.net/");
            e.metadataSources(m -> {
                m.gradleMetadata();
                m.mavenPom();
                m.artifact();
            });
        });
        new BaseRepo.Builder().add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://libraries.minecraft.net/");
            e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
        });
        hideLicense.configure(task -> task.doLast(_task -> MojangLicenseHelper.hide(project, (String)extension.getMappingChannel().get(), (String)extension.getMappingVersion().get())));
        showLicense.configure(task -> task.doLast(_task -> MojangLicenseHelper.show(project, (String)extension.getMappingChannel().get(), (String)extension.getMappingVersion().get())));
        release.configure(task -> task.dependsOn(new Object[]{sourcesJar, universalJar, userdevJar}));
        dlMappingsConfig.configure(task -> task.getMappings().convention(extension.getMappings()));
        extractNatives.configure(task -> {
            task.getMeta().set(dlMCMetaConfig.flatMap(DownloadMCMeta::getOutput));
            task.getOutput().set(project.getLayout().getBuildDirectory().dir("natives"));
        });
        downloadAssets.configure(task -> task.getMeta().set(dlMCMetaConfig.flatMap(DownloadMCMeta::getOutput)));
        applyPatches.configure(task -> {
            Provider workDir = project.getLayout().getBuildDirectory().dir(task.getName());
            task.getOutput().set(workDir.map(s -> s.file("output.zip")));
            task.getRejects().set(workDir.map(s -> s.file("rejects.zip").getAsFile()));
            task.getPatches().set((Provider)extension.getPatches());
            task.getPatchMode().set((Object)PatchMode.ACCESS);
            if (project.hasProperty("UPDATING")) {
                task.getPatchMode().set((Object)PatchMode.FUZZY);
                task.getRejects().set((Object)project.getLayout().getProjectDirectory().dir("rejects").getAsFile());
                task.setFailOnError(false);
            }
        });
        toMCPConfig.configure(task -> {
            task.getInput().set(applyPatches.flatMap(ApplyPatches::getOutput));
            task.getMappings().set(dlMappingsConfig.flatMap(DownloadMCPMappings::getOutput));
            task.setLambdas(false);
        });
        extractMapped.configure(task -> {
            task.getZip().set(toMCPConfig.flatMap(ApplyMappings::getOutput));
            task.getOutput().set((Provider)extension.getPatchedSrc());
        });
        extractRangeConfig.configure(task -> {
            task.setOnlyIf(t -> extension.getPatches().isPresent());
            task.getDependencies().from(new Object[]{jarTask.flatMap(AbstractArchiveTask::getArchiveFile)});
            task.getSources().from(new Object[]{mainSource.map(s -> s.getJava().getSourceDirectories())});
            task.getDependencies().from(new Object[]{javaCompileTask.map(JavaCompile::getClasspath)});
        });
        createMcp2Srg.configure(task -> task.setReverse(true));
        createSrg2Mcp.configure(task -> task.setReverse(false));
        createMcp2Obf.configure(task -> {
            task.setNotch(true);
            task.setReverse(true);
        });
        createExc.configure(task -> task.getMappings().set(dlMappingsConfig.flatMap(DownloadMCPMappings::getOutput)));
        applyRangeConfig.configure(task -> {
            task.getSources().from(new Object[]{mainSource.map(s -> s.getJava().getSourceDirectories().minus((FileCollection)project.files(new Object[]{extension.getPatchedSrc()})))});
            task.getRangeMap().set(extractRangeConfig.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(GenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{createExc.flatMap(CreateExc::getOutput), extension.getExcs()});
        });
        applyRangeBaseConfig.configure(task -> {
            task.setOnlyIf(t -> extension.getPatches().isPresent());
            task.getSources().from(new Object[]{extension.getPatchedSrc()});
            task.getRangeMap().set(extractRangeConfig.flatMap(ExtractRangeMap::getOutput));
            task.getSrgFiles().from(new Object[]{createMcp2Srg.flatMap(GenerateSRG::getOutput)});
            task.getExcFiles().from(new Object[]{createExc.flatMap(CreateExc::getOutput), extension.getExcs()});
        });
        genPatches.configure(task -> {
            task.setOnlyIf(t -> extension.getPatches().isPresent());
            task.getOutput().set((Provider)extension.getPatches());
        });
        bakePatches.configure(task -> {
            task.dependsOn(new Object[]{genPatches});
            task.getInput().set((Provider)extension.getPatches());
            task.getOutput().set(new File(task.getTemporaryDir(), "output.zip"));
        });
        reobfJar.configure(task -> {
            task.getInput().set(jarTask.flatMap(AbstractArchiveTask::getArchiveFile));
            task.getClasspath().from(new Object[]{project.getConfigurations().named(MC_DEP_CONFIG)});
        });
        genJoinedBinPatches.configure(task -> {
            task.getDirtyJar().set(reobfJar.flatMap(ReobfuscateJar::getOutput));
            task.getSide().set((Object)"joined");
        });
        genClientBinPatches.configure(task -> {
            task.getDirtyJar().set(reobfJar.flatMap(ReobfuscateJar::getOutput));
            task.getSide().set((Object)"client");
        });
        genServerBinPatches.configure(task -> {
            task.getDirtyJar().set(reobfJar.flatMap(ReobfuscateJar::getOutput));
            task.getSide().set((Object)"server");
        });
        genBinPatches.configure(task -> task.dependsOn(new Object[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches}));
        filterNew.configure(task -> task.getInput().set(reobfJar.flatMap(ReobfuscateJar::getOutput)));
        sourcesJar.configure(task -> {
            task.dependsOn(new Object[]{applyRangeConfig});
            task.from(new Object[]{project.zipTree((Object)applyRangeConfig.flatMap(ApplyRangeMap::getOutput))});
            task.getArchiveClassifier().set((Object)"sources");
        });
        universalJar.configure(task -> {
            task.dependsOn(new Object[]{filterNew});
            task.from(new Object[]{project.zipTree((Object)filterNew.flatMap(FilterNewJar::getOutput))});
            task.from(new Object[]{javaConv.getSourceSets().named("main").map(SourceSet::getResources)});
            task.getArchiveClassifier().set((Object)"universal");
        });
        userdevJar.configure(task -> {
            task.dependsOn(new Object[]{sourcesJar, bakePatches});
            task.setOnlyIf(t -> extension.isSrgPatches());
            task.from((Object)userdevConfig.flatMap(GenerateUserdevConfig::getOutput), e -> e.rename(f -> "config.json"));
            task.from((Object)genJoinedBinPatches.flatMap(GenerateBinPatches::getOutput), e -> e.rename(f -> "joined.lzma"));
            task.from((Object)project.zipTree((Object)bakePatches.flatMap(BakePatches::getOutput)), e -> e.into((Object)"patches/"));
            task.getArchiveClassifier().set((Object)"userdev");
        });
        boolean doingUpdate = project.hasProperty("UPDATE_MAPPINGS");
        String string = updateVersion = doingUpdate ? (String)project.property("UPDATE_MAPPINGS") : null;
        String string2 = doingUpdate ? (project.hasProperty("UPDATE_MAPPINGS_CHANNEL") ? (String)project.property("UPDATE_MAPPINGS_CHANNEL") : "snapshot") : (updateChannel = null);
        if (doingUpdate) {
            TaskProvider dlMappingsNew = tasks.register("downloadMappingsNew", DownloadMCPMappings.class);
            ((DownloadMCPMappings)((Object)dlMappingsNew.get())).getMappings().set((Object)(updateChannel + '_' + updateVersion));
            TaskProvider toMCPNew = tasks.register("srg2mcpNew", ApplyMappings.class);
            toMCPNew.configure(task -> {
                task.getInput().set(applyRangeConfig.flatMap(ApplyRangeMap::getOutput));
                task.getMappings().set(dlMappingsConfig.flatMap(DownloadMCPMappings::getOutput));
                task.setLambdas(false);
            });
            TaskProvider extractMappedNew = tasks.register("extractMappedNew", ExtractExistingFiles.class);
            extractMappedNew.configure(task -> {
                task.getArchive().set(toMCPNew.flatMap(ApplyMappings::getOutput));
                task.getTargets().from(new Object[]{mainSource.map(s -> s.getJava().getSourceDirectories().minus((FileCollection)project.files(new Object[]{extension.getPatchedSrc()})))});
            });
            TaskProvider updateMappings = tasks.register("updateMappings", DefaultTask.class);
            updateMappings.configure(task -> task.dependsOn(new Object[]{extractMappedNew}));
        }
        project.afterEvaluate(p -> {
            MCPFunction function;
            TaskProvider setupMCP;
            Project mcpParent;
            TaskProvider procConfig;
            mainSource.configure(s -> s.getJava().srcDir((Object)extension.getPatchedSrc()));
            if (extension.getPatches().isPresent()) {
                File patchesDir = ((Directory)extension.getPatches().get()).getAsFile();
                if (!patchesDir.exists() && !patchesDir.mkdirs()) {
                    p.getLogger().warn("Unable to create patches folder automatically, there may be some task errors");
                }
                sourcesJar.configure(t -> t.from((Object)genPatches.flatMap(GeneratePatches::getOutput), e -> e.into((Object)"patches/")));
            }
            TaskProvider taskProvider = procConfig = extension.getProcessor() == null ? null : tasks.register("postProcess", DynamicJarExec.class);
            if (extension.getParent().isPresent()) {
                Project parent = (Project)extension.getParent().get();
                TaskContainer parentTasks = parent.getTasks();
                MCPPlugin parentMCPPlugin = (MCPPlugin)parent.getPlugins().findPlugin(MCPPlugin.class);
                PatcherPlugin parentPatcherPlugin = (PatcherPlugin)parent.getPlugins().findPlugin(PatcherPlugin.class);
                if (parentMCPPlugin != null) {
                    MojangLicenseHelper.displayWarning(p, (String)extension.getMappingChannel().get(), (String)extension.getMappingVersion().get(), updateChannel, updateVersion);
                    TaskProvider setupMCP2 = parentTasks.named("setupMCP", SetupMCP.class);
                    Provider setupOutput = setupMCP2.flatMap(SetupMCP::getOutput);
                    if (procConfig != null) {
                        procConfig.configure(task -> {
                            task.getInput().set(setupMCP2.flatMap(SetupMCP::getOutput));
                            task.getTool().set((Object)extension.getProcessor().getVersion());
                            task.getArgs().set(extension.getProcessor().getArgs());
                            task.getData().set(extension.getProcessorData());
                        });
                        setupOutput = procConfig.flatMap(DynamicJarExec::getOutput);
                    }
                    extension.getCleanSrc().convention(setupOutput);
                    applyPatches.configure(task -> task.getBase().convention(extension.getCleanSrc().getAsFile()));
                    genPatches.configure(task -> task.getBase().convention((Provider)extension.getCleanSrc()));
                    TaskProvider downloadConfig = parentTasks.named("downloadConfig", DownloadMCPConfig.class);
                    TaskProvider extractSrg = tasks.register("extractSrg", ExtractMCPData.class);
                    extractSrg.configure(task -> task.getConfig().set(downloadConfig.flatMap(DownloadMCPConfig::getOutput)));
                    createMcp2Srg.configure(task -> task.getSrg().convention(extractSrg.flatMap(ExtractMCPData::getOutput)));
                    TaskProvider extractStatic = tasks.register("extractStatic", ExtractMCPData.class);
                    extractStatic.configure(task -> {
                        task.getConfig().set(downloadConfig.flatMap(DownloadMCPConfig::getOutput));
                        task.getKey().set((Object)"statics");
                        task.setAllowEmpty(true);
                        task.getOutput().set(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("output.txt")));
                    });
                    TaskProvider extractConstructors = tasks.register("extractConstructors", ExtractMCPData.class);
                    extractConstructors.configure(task -> {
                        task.getConfig().set(downloadConfig.flatMap(DownloadMCPConfig::getOutput));
                        task.getKey().set((Object)"constructors");
                        task.setAllowEmpty(true);
                        task.getOutput().set(project.getLayout().getBuildDirectory().dir(task.getName()).map(d -> d.file("output.txt")));
                    });
                    createExc.configure(task -> {
                        task.getConfig().convention(downloadConfig.flatMap(DownloadMCPConfig::getOutput));
                        task.getSrg().convention(createMcp2Srg.flatMap(GenerateSRG::getOutput));
                        task.getStatics().convention(extractStatic.flatMap(ExtractMCPData::getOutput));
                        task.getConstructors().convention(extractConstructors.flatMap(ExtractMCPData::getOutput));
                    });
                } else if (parentPatcherPlugin != null) {
                    PatcherExtension parentPatcher = (PatcherExtension)((Object)((Object)parent.getExtensions().getByType(PatcherExtension.class)));
                    extension.copyFrom(parentPatcher);
                    TaskProvider parentApplyPatches = parentTasks.named("applyPatches", ApplyPatches.class);
                    Provider setupOutput = parentApplyPatches.flatMap(ApplyPatches::getOutput);
                    if (procConfig != null) {
                        procConfig.configure(task -> {
                            task.getInput().set(parentApplyPatches.flatMap(ApplyPatches::getOutput));
                            task.getTool().set((Object)extension.getProcessor().getVersion());
                            task.getArgs().set(extension.getProcessor().getArgs());
                            task.getData().set(extension.getProcessorData());
                        });
                        setupOutput = procConfig.flatMap(DynamicJarExec::getOutput);
                    }
                    extension.getCleanSrc().convention(setupOutput);
                    applyPatches.configure(task -> task.getBase().convention(extension.getCleanSrc().getAsFile()));
                    genPatches.configure(task -> task.getBase().convention((Provider)extension.getCleanSrc()));
                    TaskProvider parentCreateMcp2Srg = parentTasks.named("createMcp2Srg", GenerateSRG.class);
                    createMcp2Srg.configure(task -> task.getSrg().convention(parentCreateMcp2Srg.flatMap(GenerateSRG::getSrg)));
                    TaskProvider parentCreateExc = parentTasks.named("createExc", CreateExc.class);
                    createExc.configure(task -> {
                        task.getConfig().convention(parentCreateExc.flatMap(CreateExc::getConfig));
                        task.getSrg().convention(parentCreateExc.flatMap(CreateExc::getSrg));
                        task.getStatics().convention(parentCreateExc.flatMap(CreateExc::getStatics));
                        task.getConstructors().convention(parentCreateExc.flatMap(CreateExc::getConstructors));
                    });
                    for (TaskProvider binPatchesTask : Lists.newArrayList((Object[])new TaskProvider[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches})) {
                        TaskProvider parentBinPatchesTask = parentTasks.named(binPatchesTask.getName(), GenerateBinPatches.class);
                        binPatchesTask.configure(task -> task.getPatchSets().from(new Object[]{parentBinPatchesTask.map(GenerateBinPatches::getPatchSets)}));
                    }
                    filterNew.configure(task -> task.getBlacklist().from(new Object[]{parentTasks.named("jar", Jar.class).flatMap(AbstractArchiveTask::getArchiveFile)}));
                } else {
                    throw new IllegalStateException("Parent must either be a Patcher or MCP project");
                }
                dlMappingsConfig.configure(task -> task.getMappings().convention(extension.getMappings()));
                for (TaskProvider genSrg : Arrays.asList(createMcp2Srg, createSrg2Mcp, createMcp2Obf)) {
                    genSrg.configure(task -> task.getMappings().convention(dlMappingsConfig.flatMap(DownloadMCPMappings::getMappings)));
                }
                createMcp2Obf.configure(task -> task.getSrg().convention(createMcp2Srg.flatMap(GenerateSRG::getSrg)));
                createSrg2Mcp.configure(task -> task.getSrg().convention(createMcp2Srg.flatMap(GenerateSRG::getSrg)));
            }
            if ((mcpParent = this.getMcpParent(project)) == null) {
                throw new IllegalStateException("Could not find MCP parent project, you must specify a parent chain to MCP.");
            }
            MCPExtension mcpParentExtension = (MCPExtension)mcpParent.getExtensions().getByType(MCPExtension.class);
            project.getDependencies().add(MC_DEP_CONFIG, (Object)mcpParentExtension.getConfig().map(ver -> "net.minecraft:client:" + ver.getVersion() + ":extra"));
            project.getDependencies().add(MC_DEP_CONFIG, (Object)extension.getMappingChannel().zip(extension.getMappingVersion(), MCPRepo::getMappingDep));
            dlMCMetaConfig.configure(task -> task.getMCVersion().convention(extension.getMcVersion()));
            if (!extension.getAccessTransformers().isEmpty()) {
                setupMCP = mcpParent.getTasks().named("setupMCP", SetupMCP.class);
                function = MCPFunctionFactory.createAT(mcpParent, new ArrayList<File>(extension.getAccessTransformers().getFiles()), Collections.emptyList());
                setupMCP.configure(task -> task.getPreDecompile().put((Object)(project.getName() + "AccessTransformer"), (Object)function));
                extension.getAccessTransformers().forEach(f -> {
                    ((Jar)userdevJar.get()).from(f, e -> e.into((Object)"ats/"));
                    ((GenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).getATs().from(new Object[]{f});
                });
            }
            if (!extension.getSideAnnotationStrippers().isEmpty()) {
                setupMCP = mcpParent.getTasks().named("setupMCP", SetupMCP.class);
                function = MCPFunctionFactory.createSAS(mcpParent, new ArrayList<File>(extension.getSideAnnotationStrippers().getFiles()), Collections.emptyList());
                setupMCP.configure(task -> task.getPreDecompile().put((Object)(project.getName() + "SideStripper"), (Object)function));
                extension.getSideAnnotationStrippers().forEach(f -> {
                    ((Jar)userdevJar.get()).from(f, e -> e.into((Object)"sas/"));
                    ((GenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).getSASs().from(new Object[]{f});
                });
            }
            TaskProvider fakePatches = null;
            PatcherExtension ext = extension;
            while (ext != null) {
                if (!ext.getSideAnnotationStrippers().isEmpty()) {
                    if (fakePatches == null) {
                        fakePatches = tasks.register("createFakeSASPatches", CreateFakeSASPatches.class);
                    }
                    PatcherExtension patcherExt = ext;
                    fakePatches.configure(task -> task.getFiles().from(new Object[]{patcherExt.getSideAnnotationStrippers()}));
                }
                if (!ext.getParent().isPresent()) continue;
                ext = (PatcherExtension)((Object)((Object)((Project)ext.getParent().get()).getExtensions().findByType(PatcherExtension.class)));
            }
            if (fakePatches != null) {
                TaskProvider fakePatchesTask = fakePatches;
                for (TaskProvider binPatchesTask : Lists.newArrayList((Object[])new TaskProvider[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches})) {
                    binPatchesTask.configure(task -> task.getPatchSets().from(new Object[]{fakePatchesTask.flatMap(CreateFakeSASPatches::getOutput)}));
                }
            }
            if (!extension.getExtraMappings().isEmpty()) {
                extension.getExtraMappings().stream().filter(e -> e instanceof File).map(e -> (File)e).forEach(e -> {
                    ((Jar)userdevJar.get()).from(e, c -> c.into((Object)"srgs/"));
                    ((GenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).getSRGs().from(new Object[]{e});
                });
                extension.getExtraMappings().stream().filter(e -> e instanceof String).map(e -> (String)e).forEach(e -> ((GenerateUserdevConfig)((Object)((Object)((Object)userdevConfig.get())))).getSRGLines().add(e));
            }
            userdevConfig.configure(task -> {
                task.getTool().convention(genJoinedBinPatches.map(JarExec::getResolvedVersion).map(ver -> "net.minecraftforge:binarypatcher:" + ver + ":fatjar"));
                task.getArguments().addAll((Object[])new String[]{"--clean", "{clean}", "--output", "{output}", "--apply", "{patch}"});
                task.getUniversal().convention(universalJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ':' + baseName + ':' + project.getVersion() + ':' + classifier + '@' + jarExt)))));
                task.getSource().convention(sourcesJar.flatMap(t -> t.getArchiveBaseName().flatMap(baseName -> t.getArchiveClassifier().flatMap(classifier -> t.getArchiveExtension().map(jarExt -> project.getGroup().toString() + ':' + baseName + ':' + project.getVersion() + ':' + classifier + '@' + jarExt)))));
                task.getPatchesOriginalPrefix().convention(genPatches.flatMap(GeneratePatches::getOriginalPrefix));
                task.getPatchesModifiedPrefix().convention(genPatches.flatMap(GeneratePatches::getModifiedPrefix));
                task.setNotchObf(extension.getNotchObf());
            });
            if (procConfig != null) {
                userdevJar.configure(task -> {
                    task.dependsOn(new Object[]{procConfig});
                    task.from(((Map)extension.getProcessorData().get()).values(), c -> c.into((Object)"processor"));
                });
                userdevConfig.configure(task -> {
                    task.setProcessor(extension.getProcessor());
                    ((Map)extension.getProcessorData().get()).forEach(task::addProcessorData);
                });
            }
            if (extension.isSrgPatches()) {
                genPatches.configure(task -> task.getModified().value(applyRangeBaseConfig.flatMap(ApplyRangeMap::getOutput)));
            } else {
                TaskProvider toMCPClean = tasks.register("srg2mcpClean", ApplyMappings.class);
                toMCPClean.configure(task -> {
                    task.dependsOn(new Object[]{applyPatches.map(DefaultTask::getDependsOn)});
                    task.getInput().fileProvider(applyPatches.flatMap(ApplyPatches::getBase));
                    task.getMappings().value(dlMappingsConfig.flatMap(DownloadMCPMappings::getOutput));
                    task.setLambdas(false);
                });
                TaskProvider dirtyZip = tasks.register("patchedZip", Zip.class);
                dirtyZip.configure(task -> {
                    task.from(new Object[]{extension.getPatchedSrc()});
                    task.getArchiveFileName().set((Object)"output.zip");
                    task.getDestinationDirectory().set(project.getLayout().getBuildDirectory().dir(task.getName()));
                });
                applyPatches.configure(task -> task.getBase().set(toMCPClean.flatMap(s -> s.getOutput().getAsFile())));
                genPatches.configure(task -> {
                    task.getBase().set(toMCPClean.flatMap(ApplyMappings::getOutput));
                    task.getModified().set(dirtyZip.flatMap(AbstractArchiveTask::getArchiveFile));
                });
            }
            Provider mcpConfigVersion = mcpParentExtension.getConfig().map(Artifact::getVersion);
            Provider version = mcpConfigVersion.map(ver -> extension.getNotchObf() ? ver.substring(0, ver.lastIndexOf(45)) : ver);
            Provider classifier = project.provider(() -> extension.getNotchObf() ? "" : ":srg");
            Provider clientJar = version.zip(classifier, (ver, cls) -> {
                File ret = MavenArtifactDownloader.generate(project, "net.minecraft:client:" + ver + cls, true);
                if (ret == null || !ret.exists()) {
                    throw new RuntimeException("Client " + (extension.getNotchObf() ? "notch" : "SRG jar not found"));
                }
                return ret;
            });
            Provider serverJar = version.zip(classifier, (ver, cls) -> {
                File ret = MavenArtifactDownloader.generate(project, "net.minecraft:server:" + ver + cls, true);
                if (ret == null || !ret.exists()) {
                    throw new RuntimeException("Server " + (extension.getNotchObf() ? "notch" : "SRG jar not found"));
                }
                return ret;
            });
            Provider joinedJar = mcpConfigVersion.zip(classifier, (ver, cls) -> {
                File ret = MavenArtifactDownloader.generate(project, "net.minecraft:joined:" + ver + cls, true);
                if (ret == null || !ret.exists()) {
                    throw new RuntimeException("Joined " + (extension.getNotchObf() ? "notch" : "SRG jar not found"));
                }
                return ret;
            });
            TaskProvider srg = extension.getNotchObf() ? createMcp2Obf : createMcp2Srg;
            reobfJar.configure(t -> t.getSrg().set(srg.flatMap(GenerateSRG::getOutput)));
            genJoinedBinPatches.configure(t -> t.getCleanJar().convention(project.getLayout().file(joinedJar)));
            genClientBinPatches.configure(t -> t.getCleanJar().convention(project.getLayout().file(clientJar)));
            genServerBinPatches.configure(t -> t.getCleanJar().convention(project.getLayout().file(serverJar)));
            for (TaskProvider binPatchesTask : Lists.newArrayList((Object[])new TaskProvider[]{genJoinedBinPatches, genClientBinPatches, genServerBinPatches})) {
                binPatchesTask.configure(task -> {
                    task.getSrg().set(srg.flatMap(GenerateSRG::getOutput));
                    if (extension.getPatches().isPresent()) {
                        task.mustRunAfter(new Object[]{genPatches});
                        task.getPatchSets().from(new Object[]{extension.getPatches()});
                    }
                });
            }
            filterNew.configure(t -> {
                t.getSrg().set(srg.flatMap(GenerateSRG::getOutput));
                t.getBlacklist().from(new Object[]{joinedJar});
            });
            HashMap<String, Object> tokens = new HashMap<String, Object>();
            try {
                DownloadMCMeta downloadMCMetaTask = (DownloadMCMeta)((Object)((Object)dlMCMetaConfig.get()));
                File metaOutput = ((RegularFile)downloadMCMetaTask.getOutput().get()).getAsFile();
                if (!metaOutput.exists()) {
                    downloadMCMetaTask.downloadMCMeta();
                }
                VersionJson json = Utils.loadJson(metaOutput, VersionJson.class);
                tokens.put("asset_index", json.assetIndex.id);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                tokens.put("asset_index", extension.getMcVersion().get());
            }
            extension.getRuns().forEach(runConfig -> runConfig.tokens(tokens));
            Utils.createRunConfigTasks(extension, (TaskProvider<ExtractNatives>)extractNatives, downloadAssets, createSrg2Mcp);
        });
    }

    @Nullable
    private Project getMcpParent(Project project) {
        PatcherExtension extension = (PatcherExtension)((Object)project.getExtensions().findByType(PatcherExtension.class));
        if (extension == null || !extension.getParent().isPresent()) {
            return null;
        }
        Project parent = (Project)extension.getParent().get();
        MCPPlugin mcp = (MCPPlugin)parent.getPlugins().findPlugin(MCPPlugin.class);
        PatcherPlugin patcher = (PatcherPlugin)parent.getPlugins().findPlugin(PatcherPlugin.class);
        if (mcp != null) {
            return parent;
        }
        if (patcher != null) {
            return this.getMcpParent(parent);
        }
        return null;
    }
}

