/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.mcp.tasks.DownloadMCPConfig;
import net.minecraftforge.gradle.mcp.tasks.SetupMCP;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.tasks.TaskProvider;

public class MCPPlugin
implements Plugin<Project> {
    public void apply(@Nonnull Project project) {
        MCPExtension extension = (MCPExtension)project.getExtensions().create("mcp", MCPExtension.class, new Object[]{project});
        TaskProvider downloadConfig = project.getTasks().register("downloadConfig", DownloadMCPConfig.class);
        TaskProvider setupMCP = project.getTasks().register("setupMCP", SetupMCP.class);
        downloadConfig.configure(task -> {
            task.getConfig().set(extension.getConfig().map(Artifact::getDescriptor));
            task.getOutput().set(project.getLayout().getBuildDirectory().file("mcp_config.zip"));
        });
        setupMCP.configure(task -> {
            task.getPipeline().set(extension.getPipeline());
            task.getConfig().set(downloadConfig.flatMap(DownloadMCPConfig::getOutput));
        });
        project.afterEvaluate(p -> {
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
            });
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://maven.minecraftforge.net/");
                e.metadataSources(m -> {
                    m.gradleMetadata();
                    m.mavenPom();
                    m.artifact();
                });
            });
            project.getRepositories().mavenCentral();
        });
    }
}

