/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.DownloadMCMeta;
import net.minecraftforge.gradle.common.task.DownloadMavenArtifact;
import net.minecraftforge.gradle.common.task.ExtractMCPData;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.task.TaskApplyMappings;
import net.minecraftforge.gradle.common.task.TaskApplyRangeMap;
import net.minecraftforge.gradle.common.task.TaskExtractExistingFiles;
import net.minecraftforge.gradle.common.task.TaskExtractRangeMap;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.MojangLicenseHelper;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.mcp.task.DownloadMCPMappingsTask;
import net.minecraftforge.gradle.mcp.task.GenerateSRG;
import net.minecraftforge.gradle.userdev.DependencyManagementExtension;
import net.minecraftforge.gradle.userdev.MinecraftUserRepo;
import net.minecraftforge.gradle.userdev.UserDevExtension;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import net.minecraftforge.gradle.userdev.util.DeobfuscatingRepo;
import net.minecraftforge.gradle.userdev.util.Deobfuscator;
import net.minecraftforge.gradle.userdev.util.DependencyRemapper;
import net.minecraftforge.srgutils.IMappingFile;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class UserDevPlugin
implements Plugin<Project> {
    private static String MINECRAFT = "minecraft";
    public static String OBF = "__obfuscated";

    public void apply(@Nonnull Project project) {
        Utils.checkEnvironment();
        Logger logger = project.getLogger();
        UserDevExtension extension = (UserDevExtension)((Object)project.getExtensions().create("minecraft", UserDevExtension.class, new Object[]{project}));
        if (project.getPluginManager().findPlugin("java") == null) {
            project.getPluginManager().apply("java");
        }
        File nativesFolder = project.file((Object)"build/natives/");
        NamedDomainObjectContainer reobf = project.container(RenameJarInPlace.class, jarName -> {
            String name = Character.toUpperCase(jarName.charAt(0)) + jarName.substring(1);
            JavaPluginConvention java = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
            RenameJarInPlace task = (RenameJarInPlace)((Object)((Object)project.getTasks().maybeCreate("reobf" + name, RenameJarInPlace.class)));
            task.setClasspath(((SourceSet)java.getSourceSets().getByName("main")).getCompileClasspath());
            Task createMcpToSrg = (Task)project.getTasks().findByName("createMcpToSrg");
            if (createMcpToSrg != null) {
                task.setMappings(() -> createMcpToSrg.getOutputs().getFiles().getSingleFile());
            }
            project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
            project.afterEvaluate(p -> {
                Task jar = project.getTasks().getByName(jarName);
                if (!(jar instanceof Jar)) {
                    throw new IllegalStateException(jarName + "  is not a jar task. Can only reobf jars!");
                }
                task.setInput(((RegularFile)((Jar)jar).getArchiveFile().get()).getAsFile());
                task.dependsOn(new Object[]{jar});
                if (createMcpToSrg != null && task.getMappings().equals(createMcpToSrg.getOutputs().getFiles().getSingleFile())) {
                    task.dependsOn(new Object[]{createMcpToSrg});
                }
            });
            return task;
        });
        project.getExtensions().add("reobf", (Object)reobf);
        Configuration minecraft = (Configuration)project.getConfigurations().maybeCreate(MINECRAFT);
        for (String cfg : new String[]{"compile", "implementation"}) {
            Configuration c = (Configuration)project.getConfigurations().findByName(cfg);
            if (c == null) continue;
            c.extendsFrom(new Configuration[]{minecraft});
        }
        Configuration internalObfConfiguration = (Configuration)project.getConfigurations().maybeCreate(OBF);
        internalObfConfiguration.setDescription("Generated scope for obfuscated dependencies");
        Deobfuscator deobfuscator = new Deobfuscator(project, Utils.getCache(project, "deobf_dependencies"));
        DependencyRemapper remapper = new DependencyRemapper(project, deobfuscator);
        project.getExtensions().create("fg", DependencyManagementExtension.class, new Object[]{project, remapper});
        TaskProvider downloadMcpConfig = project.getTasks().register("downloadMcpConfig", DownloadMavenArtifact.class);
        TaskProvider extractSrg = project.getTasks().register("extractSrg", ExtractMCPData.class);
        TaskProvider createSrgToMcp = project.getTasks().register("createSrgToMcp", GenerateSRG.class);
        TaskProvider createMcpToSrg = project.getTasks().register("createMcpToSrg", GenerateSRG.class);
        TaskProvider downloadMCMeta = project.getTasks().register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = project.getTasks().register("extractNatives", ExtractNatives.class);
        TaskProvider downloadAssets = project.getTasks().register("downloadAssets", DownloadAssets.class);
        extractSrg.configure(task -> {
            task.dependsOn(new Object[]{downloadMcpConfig});
            task.setConfig(() -> ((DownloadMavenArtifact)((Object)((Object)((Object)downloadMcpConfig.get())))).getOutput());
        });
        createSrgToMcp.configure(task -> {
            task.setReverse(false);
            task.dependsOn(new Object[]{extractSrg});
            task.setSrg(((ExtractMCPData)((Object)((Object)extractSrg.get()))).getOutput());
            task.setMappings(extension.getMappings());
            task.setFormat(IMappingFile.Format.SRG);
            task.setOutput(project.file((Object)("build/" + createSrgToMcp.getName() + "/output.srg")));
        });
        createMcpToSrg.configure(task -> {
            task.setReverse(true);
            task.dependsOn(new Object[]{extractSrg});
            task.setSrg(((ExtractMCPData)((Object)((Object)extractSrg.get()))).getOutput());
            task.setMappings(extension.getMappings());
        });
        extractNatives.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
            task.setOutput(nativesFolder);
        });
        downloadAssets.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
        });
        if (project.hasProperty("UPDATE_MAPPINGS")) {
            String version = (String)project.property("UPDATE_MAPPINGS");
            String channel = project.hasProperty("UPDATE_MAPPINGS_CHANNEL") ? (String)project.property("UPDATE_MAPPINGS_CHANNEL") : "snapshot";
            logger.lifecycle("This process uses Srg2Source for java source file renaming. Please forward relevant bug reports to https://github.com/MinecraftForge/Srg2Source/issues.");
            MojangLicenseHelper.displayWarning(project, channel);
            JavaCompile javaCompile = (JavaCompile)project.getTasks().getByName("compileJava");
            JavaPluginConvention javaConv = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
            Set srcDirs = ((SourceSet)javaConv.getSourceSets().getByName("main")).getJava().getSrcDirs();
            TaskProvider dlMappingsNew = project.getTasks().register("downloadMappingsNew", DownloadMCPMappingsTask.class);
            TaskProvider extractRangeConfig = project.getTasks().register("extractRangeMap", TaskExtractRangeMap.class);
            TaskProvider applyRangeConfig = project.getTasks().register("applyRangeMap", TaskApplyRangeMap.class);
            TaskProvider toMCPNew = project.getTasks().register("srg2mcpNew", TaskApplyMappings.class);
            TaskProvider extractMappedNew = project.getTasks().register("extractMappedNew", TaskExtractExistingFiles.class);
            extractRangeConfig.configure(task -> {
                task.addSources(srcDirs);
                task.addDependencies(javaCompile.getClasspath());
            });
            applyRangeConfig.configure(task -> {
                task.dependsOn(new Object[]{extractRangeConfig, createMcpToSrg});
                task.setRangeMap(((TaskExtractRangeMap)((Object)((Object)extractRangeConfig.get()))).getOutput());
                task.setSrgFiles(((GenerateSRG)((Object)((Object)createMcpToSrg.get()))).getOutput());
                task.setSources(srcDirs);
            });
            dlMappingsNew.configure(task -> {
                task.setMappings(channel + "_" + version);
                task.setOutput(project.file((Object)"build/mappings_new.zip"));
            });
            toMCPNew.configure(task -> {
                task.dependsOn(new Object[]{dlMappingsNew, applyRangeConfig});
                task.setInput(((TaskApplyRangeMap)((Object)((Object)applyRangeConfig.get()))).getOutput());
                task.setMappings(((DownloadMCPMappingsTask)((Object)((Object)dlMappingsNew.get()))).getOutput());
            });
            extractMappedNew.configure(task -> {
                task.dependsOn(new Object[]{toMCPNew});
                task.setArchive(((TaskApplyMappings)((Object)((Object)toMCPNew.get()))).getOutput());
                srcDirs.forEach(task::addTarget);
            });
            TaskProvider updateMappings = project.getTasks().register("updateMappings", DefaultTask.class);
            ((DefaultTask)updateMappings.get()).dependsOn(new Object[]{extractMappedNew});
        }
        project.afterEvaluate(p -> {
            MojangLicenseHelper.displayWarning(p, extension.getMappingChannel());
            MinecraftUserRepo mcrepo = null;
            DeobfuscatingRepo deobfrepo = null;
            DependencySet deps = minecraft.getDependencies();
            for (Dependency dep : new ArrayList(deps)) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException("minecraft dependency must be a maven dependency.");
                }
                if (mcrepo != null) {
                    throw new IllegalArgumentException("Only allows one minecraft dependency.");
                }
                deps.remove((Object)dep);
                mcrepo = new MinecraftUserRepo((Project)p, dep.getGroup(), dep.getName(), dep.getVersion(), extension.getAccessTransformers(), extension.getMappings());
                String newDep = mcrepo.getDependencyString();
                ExternalModuleDependency ext = (ExternalModuleDependency)p.getDependencies().create((Object)newDep);
                minecraft.resolutionStrategy(strat -> strat.cacheChangingModulesFor(10, TimeUnit.SECONDS));
                minecraft.getDependencies().add((Object)ext);
            }
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://files.minecraftforge.net/maven/");
                e.metadataSources(m -> {
                    m.gradleMetadata();
                    m.mavenPom();
                    m.artifact();
                });
            });
            if (!internalObfConfiguration.getDependencies().isEmpty() && (deobfrepo = new DeobfuscatingRepo(project, internalObfConfiguration, deobfuscator)).getResolvedOrigin() == null) {
                project.getLogger().error("DeobfRepo attempted to resolve an origin repo early but failed, this may cause issues with some IDEs");
            }
            remapper.attachMappings(extension.getMappings());
            new BaseRepo.Builder().add(mcrepo).add(deobfrepo).add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
            });
            project.getRepositories().mavenCentral();
            if (mcrepo == null) {
                throw new IllegalStateException("Missing 'minecraft' dependency entry.");
            }
            mcrepo.validate(minecraft, extension.getRuns().getAsMap(), (ExtractNatives)((Object)((Object)extractNatives.get())), (DownloadAssets)((Object)((Object)downloadAssets.get())), (GenerateSRG)((Object)((Object)createSrgToMcp.get())));
            String mcVer = (String)project.getExtensions().getExtraProperties().get("MC_VERSION");
            String mcpVer = (String)project.getExtensions().getExtraProperties().get("MCP_VERSION");
            ((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).setArtifact("de.oceanlabs.mcp:mcp_config:" + mcpVer + "@zip");
            ((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).setMCVersion(mcVer);
            RenameJarInPlace reobfJar = (RenameJarInPlace)((Object)((Object)reobf.create("jar")));
            reobfJar.dependsOn(new Object[]{createMcpToSrg});
            reobfJar.setMappings(((GenerateSRG)((Object)((Object)createMcpToSrg.get()))).getOutput());
            String assetIndex = mcVer;
            try {
                if (!((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput().exists()) {
                    ((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).downloadMCMeta();
                }
                VersionJson json = Utils.loadJson(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput(), VersionJson.class);
                assetIndex = json.assetIndex.id;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            String finalAssetIndex = assetIndex;
            extension.getRuns().forEach(runConfig -> runConfig.token("asset_index", finalAssetIndex));
            Utils.createRunConfigTasks(extension, (ExtractNatives)((Object)((Object)extractNatives.get())), (Task)downloadAssets.get(), (Task)createSrgToMcp.get());
        });
    }
}

