/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.task;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.gradle.common.config.MCPConfigV2;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class SetupMCPTask
extends DefaultTask {
    private File config;
    private String pipeline;
    private Map<String, MCPFunction> extrasPre = new LinkedHashMap<String, MCPFunction>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));

    public SetupMCPTask() {
        this.getOutputs().upToDateWhen(task -> {
            HashStore cache = new HashStore(this.getProject());
            try {
                cache.load(this.getProject().file((Object)("build/" + this.getName() + "/inputcache.sha1")));
                cache.add("configFile", this.config);
                this.extrasPre.forEach((key, func) -> func.addInputs(cache, key + "."));
                cache.save();
                return cache.isSame() && this.getOutput().exists();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        });
    }

    @InputFile
    public File getConfig() {
        return this.config;
    }

    public void setConfig(File value) {
        this.config = value;
    }

    @Input
    public String getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(String value) {
        this.pipeline = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @TaskAction
    public void setupMCP() throws Exception {
        MCPConfigV2 mcpconfig = MCPConfigV2.getFromArchive(this.config);
        MCPRuntime runtime = new MCPRuntime(this.getProject(), this.config, mcpconfig, this.getPipeline(), this.getProject().file((Object)"build/mcp/"), this.extrasPre);
        File out = runtime.execute(this.getLogger());
        if (FileUtils.contentEquals((File)out, (File)this.output)) {
            return;
        }
        Utils.delete(this.output);
        FileUtils.copyFile((File)out, (File)this.output);
    }

    public void addPreDecompile(String name, MCPFunction function) {
        this.extrasPre.put(name, function);
    }
}

