/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.mcp.MCPRepo;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadMCPMappingsTask
extends DefaultTask {
    private String mappings;
    private File output = this.getProject().file((Object)"build/mappings.zip");

    @Input
    public String getMappings() {
        return this.mappings;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @TaskAction
    public void download() throws IOException {
        File out = this.getMappingFile();
        this.setDidWork(out != null && out.exists());
        if (FileUtils.contentEquals((File)out, (File)this.output)) {
            return;
        }
        if (this.output.exists()) {
            this.output.delete();
        }
        if (!this.output.getParentFile().exists()) {
            this.output.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)out, (File)this.output);
    }

    private File getMappingFile() {
        int idx = this.getMappings().lastIndexOf(95);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid mapping string format, must be {channel}_{version}.");
        }
        String channel = this.getMappings().substring(0, idx);
        String version = this.getMappings().substring(idx + 1);
        String artifact = MCPRepo.getMappingDep(channel, version);
        File ret = MavenArtifactDownloader.generate(this.getProject(), artifact, false);
        if (ret == null) {
            throw new IllegalStateException("Failed to download mappings: " + artifact);
        }
        return ret;
    }
}

