/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import javax.annotation.Nonnull;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.mcp.task.DownloadMCPConfigTask;
import net.minecraftforge.gradle.mcp.task.SetupMCPTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.tasks.TaskProvider;

public class MCPPlugin
implements Plugin<Project> {
    public void apply(@Nonnull Project project) {
        MCPExtension extension = (MCPExtension)project.getExtensions().create("mcp", MCPExtension.class, new Object[]{project});
        TaskProvider downloadConfig = project.getTasks().register("downloadConfig", DownloadMCPConfigTask.class);
        TaskProvider setupMCP = project.getTasks().register("setupMCP", SetupMCPTask.class);
        downloadConfig.configure(task -> {
            task.setConfig(extension.getConfig().toString());
            task.setOutput(project.file((Object)"build/mcp_config.zip"));
        });
        setupMCP.configure(task -> {
            task.dependsOn(new Object[]{downloadConfig});
            task.setPipeline(extension.pipeline);
            task.setConfig(((DownloadMCPConfigTask)((Object)((Object)downloadConfig.get()))).getOutput());
        });
        project.afterEvaluate(p -> {
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
            });
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://files.minecraftforge.net/maven/");
                e.metadataSources(m -> {
                    m.gradleMetadata();
                    m.mavenPom();
                    m.artifact();
                });
            });
            project.getRepositories().mavenCentral();
        });
    }
}

