/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraftforge.artifactural.api.artifact.ArtifactIdentifier;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.specs.Spec;

public class Artifact
implements ArtifactIdentifier,
Comparable<Artifact> {
    private String group;
    private String name;
    private String version;
    private String classifier = null;
    private String ext = "jar";
    private String path;
    private String file;
    private String descriptor;
    private ComparableVersion comp;
    private boolean isSnapshot = false;

    public static Artifact from(String descriptor) {
        Artifact ret = new Artifact();
        ret.descriptor = descriptor;
        String[] pts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)descriptor), String.class);
        ret.group = pts[0];
        ret.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ret.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        ret.version = pts[2];
        ret.comp = new ComparableVersion(ret.version);
        ret.isSnapshot = ret.version.toLowerCase(Locale.ENGLISH).endsWith("-snapshot");
        if (pts.length > 3) {
            ret.classifier = pts[3];
        }
        ret.file = ret.name + '-' + ret.version;
        if (ret.classifier != null) {
            ret.file = ret.file + '-' + ret.classifier;
        }
        ret.file = ret.file + '.' + ret.ext;
        ret.path = String.join((CharSequence)"/", ret.group.replace('.', '/'), ret.name, ret.version, ret.file);
        return ret;
    }

    public static Artifact from(ArtifactIdentifier identifier) {
        if (identifier instanceof Artifact) {
            return (Artifact)identifier;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(identifier.getGroup()).append(':').append(identifier.getName()).append(':').append(identifier.getVersion());
        if (identifier.getClassifier() != null && !identifier.getClassifier().isEmpty()) {
            builder.append(':').append(identifier.getClassifier());
        }
        builder.append('@');
        if (identifier.getExtension() == null || identifier.getExtension().isEmpty()) {
            builder.append("jar");
        } else {
            builder.append(identifier.getExtension());
        }
        return Artifact.from(builder.toString());
    }

    public static Artifact from(String group, String name, String version, String classifier, String ext) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(':').append(name).append(':').append(version);
        if (classifier != null) {
            buf.append(':').append(classifier);
        }
        if (ext != null && !"jar".equals(ext)) {
            buf.append('@').append(ext);
        }
        return Artifact.from(buf.toString());
    }

    public File getLocalFile(File base) {
        return new File(base, this.getLocalPath());
    }

    public String getLocalPath() {
        return this.path.replace('/', File.separatorChar);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        return this.file;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public Artifact withVersion(String version) {
        return Artifact.from(this.group, this.name, version, this.classifier, this.ext);
    }

    public String toString() {
        return this.getDescriptor();
    }

    public Spec<Dependency> asDependencySpec() {
        return dep -> this.group.equals(dep.getGroup()) && this.name.equals(dep.getName()) && this.version.equals(dep.getVersion());
    }

    public Predicate<ResolvedArtifact> asArtifactMatcher() {
        return art -> {
            String theirClassifier = art.getClassifier() == null ? "" : art.getClassifier();
            String theirExt = art.getExtension().isEmpty() ? "jar" : art.getExtension();
            return !(this.classifier != null && !this.classifier.equals(theirClassifier) || this.ext != null && !this.ext.equals(theirExt));
        };
    }

    @Override
    public int compareTo(Artifact o) {
        int ret = 0;
        ret = this.group.compareTo(o.group);
        if (ret != 0) {
            return ret;
        }
        ret = this.name.compareTo(o.name);
        if (ret != 0) {
            return ret;
        }
        ret = this.comp.compareTo(o.comp);
        if (ret != 0) {
            return ret;
        }
        if (this.isSnapshot) {
            // empty if block
        }
        if ((ret = this.classifier.compareTo(o.classifier)) != 0) {
            return ret;
        }
        return this.ext.compareTo(o.ext);
    }
}

