/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.SrgJarRenamer;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;

public class ModRemapingRepo
extends BaseRepo {
    private final Project project;
    private final String MAPPING;
    private final Map<String, Artifact> external = new HashMap<String, Artifact>();
    private Repository repo;

    public ModRemapingRepo(Project project, String mapping) {
        super(Utils.getCache(project, "mod_remap_repo"), project.getLogger());
        this.project = project;
        this.MAPPING = mapping;
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).provide((ArtifactProvider)this));
    }

    private File cache(Artifact artifact, String mapping) {
        return this.cache(artifact, mapping, artifact.getClassifier());
    }

    private File cache(Artifact artifact, String mapping, String classifier) {
        return this.cache(artifact, mapping, classifier, artifact.getExtension());
    }

    private File cache(Artifact artifact, String mapping, String classifier, String extension) {
        return this.cache(artifact.getGroup(), artifact.getName(), artifact.getVersion(), classifier, extension, mapping);
    }

    private File cache(String group, String name, String version, String classifier, String ext, String mapping) {
        if (mapping != null) {
            version = version + "_mapped_" + mapping;
        }
        if (ext == null) {
            ext = "jar";
        }
        String filename = name + '-' + version;
        if (classifier != null) {
            filename = filename + '-' + classifier;
        }
        filename = filename + '.' + ext;
        return this.cache(group.replace('.', File.separatorChar), name, version, filename);
    }

    public String addDep(String group, String name, String version) {
        String str = group + ':' + name + ':' + version;
        String map = str = str + "_mapped_" + this.MAPPING;
        this.external.put(map, Artifact.from(str));
        return map;
    }

    private String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[1];
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String desc;
        Artifact orig;
        String group = artifact.getGroup();
        String version = artifact.getVersion();
        String mappings = this.getMappings(version);
        if (mappings == null) {
            return null;
        }
        if (mappings != null) {
            version = version.substring(0, version.length() - (mappings.length() + "_mapped_".length()));
        }
        if ((orig = this.external.get(desc = group + ':' + artifact.getName() + ':' + artifact.getVersion())) == null) {
            return null;
        }
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + artifact.getName() + ":" + version + ":" + classifier + "@" + ext + " Mapping: " + mappings);
        if (!"pom".equals(ext)) {
            switch (classifier) {
                case "": {
                    return this.findRaw(orig, mappings);
                }
                case "sources": {
                    return this.findSource(orig, mappings);
                }
            }
        }
        return null;
    }

    private File findMapping(String mapping) {
        if (mapping == null) {
            return null;
        }
        int idx = mapping.lastIndexOf(95);
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = "de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip";
        this.debug("    Mapping: " + desc);
        return MavenArtifactDownloader.manual(this.project, desc, false);
    }

    private File findPom(Artifact artifact, String mapping) throws IOException {
        if (mapping == null) {
            return null;
        }
        File clean = MavenArtifactDownloader.manual(this.project, artifact.getGroup() + ':' + artifact.getName() + ':' + artifact.getVersion() + "@pom", false);
        if (clean == null || !clean.exists()) {
            return null;
        }
        File pom = this.cache(artifact, mapping, null, "pom");
        this.debug("  Finding pom: " + pom);
        HashStore cache = new HashStore().load(new File(pom.getAbsolutePath() + ".input")).add("pom", pom);
        if (!cache.isSame() || !pom.exists()) {
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private File findRaw(Artifact artifact, String mapping) throws IOException {
        File names = this.findMapping(mapping);
        if (names == null || !names.exists()) {
            return null;
        }
        File orig = MavenArtifactDownloader.manual(this.project, artifact.getDescriptor(), false);
        if (orig == null || !orig.exists()) {
            return null;
        }
        HashStore cache = new HashStore().load(this.cache(artifact, mapping, null, "jar.input")).add("names", names).add("orig", orig);
        File ret = this.cache(artifact, mapping, null, "jar");
        if (!cache.isSame() || !ret.exists()) {
            SrgJarRenamer.rename(orig, ret, names);
            Utils.updateHash(ret, HashFunction.SHA1);
            cache.save();
        }
        return ret;
    }

    private File findSource(Artifact artifact, String mapping) throws IOException {
        File names = this.findMapping(mapping);
        if (names == null || !names.exists()) {
            return null;
        }
        File orig = MavenArtifactDownloader.manual(this.project, artifact.getGroup() + ':' + artifact.getName() + ':' + artifact.getVersion() + ":sources", false);
        if (orig == null || !orig.exists()) {
            return null;
        }
        HashStore cache = new HashStore().load(this.cache(artifact, mapping, "sources", "jar.input")).add("names", names).add("orig", orig);
        File ret = this.cache(artifact, mapping, "sources", "jar");
        if (!cache.isSame() || !ret.exists()) {
            McpNames map = McpNames.load(names);
            if (!ret.getParentFile().exists()) {
                ret.getParentFile().mkdirs();
            }
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(orig));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(ret));){
                ZipEntry _old;
                while ((_old = zin.getNextEntry()) != null) {
                    ZipEntry _new = new ZipEntry(_old.getName());
                    _new.setTime(0L);
                    zout.putNextEntry(_new);
                    if (_old.getName().endsWith(".java")) {
                        String mapped = map.rename(zin, true);
                        IOUtils.write((String)mapped, (OutputStream)zout);
                        continue;
                    }
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                }
            }
            Utils.updateHash(ret, HashFunction.SHA1);
            cache.save();
        }
        return ret;
    }
}

