/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.gradle.common.util.ChainedInputSupplier;
import net.minecraftforge.srg2source.ast.RangeExtractor;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskExtractRangeMap
extends DefaultTask {
    private Set<File> sources;
    private Set<FileCollection> dependencies = new HashSet<FileCollection>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.txt"));
    private File log = this.getProject().file((Object)("build/" + this.getName() + "/log.txt"));

    @TaskAction
    public void extractRangeMap() throws IOException {
        Throwable throwable;
        RangeExtractor extract = new RangeExtractor("1.8");
        for (FileCollection files : this.getDependencies()) {
            for (File file : files) {
                extract.addLibs(file);
            }
        }
        if (this.getOutput().exists()) {
            throwable = null;
            try (FileInputStream fin = new FileInputStream(this.getOutput());){
                extract.loadCache((InputStream)fin);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        extract.setSrc(this.getInputSupplier());
        throwable = null;
        try (FileOutputStream fos = new FileOutputStream(this.log);){
            extract.setOutLogger(new PrintStream(fos));
            if (!extract.generateRangeMap(this.getOutput())) {
                throw new RuntimeException("RangeExtractor failed, Check Log for details: " + this.log);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private InputSupplier getInputSupplier() throws IOException {
        ChainedInputSupplier inputs = new ChainedInputSupplier(new InputSupplier[0]);
        for (File src : this.getSources()) {
            if (!src.exists()) continue;
            inputs.add((InputSupplier)(src.isDirectory() ? new FolderSupplier(src) : new ZipInputSupplier(src)));
        }
        return inputs.shrink();
    }

    @InputFiles
    public Set<File> getSources() {
        return this.sources;
    }

    @InputFiles
    public Set<FileCollection> getDependencies() {
        return this.dependencies;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setSources(Set<File> sources) {
        this.sources = sources;
    }

    public void addSources(Set<File> values) {
        if (this.sources == null) {
            this.sources = new HashSet<File>();
        }
        this.sources.addAll(values);
    }

    public void addDependencies(FileCollection dependencies) {
        this.dependencies.add(dependencies);
    }

    public void addDependencies(File ... dependencies) {
        for (File dep : dependencies) {
            this.dependencies.add((FileCollection)this.getProject().files(new Object[]{dep}));
        }
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

