/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;

public class GenerateBinPatches
extends JarExec {
    private File cleanJar;
    private File dirtyJar;
    private File srg;
    private Set<File> patchSets = new HashSet<File>();
    private String side;
    private File output = null;

    public GenerateBinPatches() {
        this.tool = "net.minecraftforge:binarypatcher:1.+:fatjar";
        this.args = new String[]{"--clean", "{clean}", "--create", "{dirty}", "--output", "{output}", "--patches", "{patches}", "--srg", "{srg}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{clean}", this.getCleanJar().getAbsolutePath());
        replace.put("{dirty}", this.getDirtyJar().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{srg}", this.getSrg().getAbsolutePath());
        ArrayList<String> _args = new ArrayList<String>();
        for (String arg : this.getArgs()) {
            if ("{patches}".equals(arg)) {
                String prefix = (String)_args.get(_args.size() - 1);
                _args.remove(_args.size() - 1);
                this.getPatchSets().forEach(f -> {
                    _args.add(prefix);
                    _args.add(f.getAbsolutePath());
                });
                continue;
            }
            _args.add(replace.getOrDefault(arg, arg));
        }
        return _args;
    }

    @InputFile
    public File getCleanJar() {
        return this.cleanJar;
    }

    public void setCleanJar(File value) {
        this.cleanJar = value;
    }

    @InputFile
    public File getDirtyJar() {
        return this.dirtyJar;
    }

    public void setDirtyJar(File value) {
        this.dirtyJar = value;
    }

    @InputFiles
    public Set<File> getPatchSets() {
        return this.patchSets;
    }

    public void addPatchSet(File value) {
        if (value != null) {
            this.patchSets.add(value);
        }
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @Input
    public String getSide() {
        return this.side;
    }

    public void setSide(String value) {
        this.side = value;
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/" + this.getSide() + ".lzma")));
        }
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/output.lzma")));
        }
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

