/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;

public class PatcherExtension {
    public Project parent;
    public File cleanSrc;
    public File patchedSrc;
    public File patches;
    public String mcVersion;
    public boolean srgPatches = true;
    private String mappings;
    private List<Object> extraMappings = new ArrayList<Object>();
    private List<Object> extraExcs = new ArrayList<Object>();
    private List<File> accessTransformers = new ArrayList<File>();
    private List<File> excs = new ArrayList<File>();
    private RunConfig.Container runs = new RunConfig.Container();

    @Inject
    public PatcherExtension(Project project) {
        RunConfig clientRun = new RunConfig();
        clientRun.setMain("mcp.client.Start");
        try {
            clientRun.setWorkingDirectory(project.file((Object)"run").getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.runs.getRuns().put(project.getName() + "_client", clientRun);
        RunConfig serverRun = new RunConfig();
        serverRun.setMain("net.minecraft.server.MinecraftServer");
        try {
            serverRun.setWorkingDirectory(project.file((Object)"run").getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.runs.getRuns().put(project.getName() + "_server", serverRun);
    }

    public List<Object> getExtraMappings() {
        return this.extraMappings;
    }

    public List<Object> getExtraExcs() {
        return this.extraExcs;
    }

    public void mappings(Map<String, String> map) {
        String channel = map.get("channel");
        String version = map.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify mappings channel and version");
        }
        if (!version.contains("-")) {
            version = version + "-+";
        }
        this.setMappings("de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip");
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public String getMappings() {
        return this.mappings;
    }

    public void extraMapping(Object mapping) {
        if (!(mapping instanceof String) && !(mapping instanceof File)) {
            throw new IllegalArgumentException("Extra mappings must be a file or a string!");
        }
        this.extraMappings.add(mapping);
    }

    public void extraExc(Object exc) {
        this.extraExcs.add(exc);
    }

    void copyFrom(PatcherExtension other) {
        if (this.mappings == null) {
            this.setMappings(other.getMappings());
        }
        if (this.mcVersion == null) {
            this.mcVersion = other.mcVersion;
        }
    }

    public void accessTransformer(File file) {
        this.setAccessTransformer(file);
    }

    public void setAccessTransformer(File file) {
        this.accessTransformers.add(file);
    }

    public void setAccessTransformers(List<File> files) {
        this.accessTransformers.clear();
        this.accessTransformers.addAll(files);
    }

    public List<File> getAccessTransformers() {
        return this.accessTransformers;
    }

    public void exc(File file) {
        this.setExc(file);
    }

    public void setExc(File file) {
        this.excs.add(file);
    }

    public void setExc(List<File> files) {
        this.excs.clear();
        this.excs.addAll(files);
    }

    public List<File> getExcs() {
        return this.excs;
    }

    public void runs(Closure<? super RunConfig.Container> value) {
        value.setResolveStrategy(1);
        value.setDelegate((Object)this.runs);
        value.call();
    }

    public Map<String, RunConfig> getRuns() {
        return this.runs.getRuns();
    }
}

