/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Joiner;
import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.tasks.SourceSet;

public class RunConfig
implements Serializable {
    private static final String MCP_CLIENT_MAIN = "mcp.client.Start";
    private static final String MC_CLIENT_MAIN = "net.minecraft.client.main.Main";
    private static final long serialVersionUID = 1L;
    private String main;
    private List<String> args;
    private List<String> jvmArgs;
    private Map<String, String> env;
    private Map<String, String> props;
    private boolean singleInstance = false;
    private String ideaModule;
    private String workDir;
    private List<SourceSet> sources;

    public void environment(Map<String, Object> map) {
        this.setEnvironment(map);
    }

    public void setEnvironment(Map<String, Object> map) {
        map.forEach((k, v) -> this.getEnvironment().put((String)k, v instanceof File ? ((File)v).getAbsolutePath() : (String)v));
    }

    public void environment(String key, String value) {
        this.getEnvironment().put(key, value);
    }

    public void environment(String key, File value) {
        this.getEnvironment().put(key, value.getAbsolutePath());
    }

    public Map<String, String> getEnvironment() {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        return this.env;
    }

    public void main(String value) {
        this.setMain(value);
    }

    public void setMain(String value) {
        this.main = value;
    }

    public String getMain() {
        return this.main;
    }

    public void arg(String value) {
        this.getArgs().add(value);
    }

    public void setArgs(List<String> values) {
        this.getArgs().addAll(values);
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        return this.args;
    }

    public void jvmArg(String value) {
        this.getJvmArgs().add(value);
    }

    public void jvmArgs(List<String> values) {
        this.getJvmArgs().addAll(values);
    }

    public List<String> getJvmArgs() {
        if (this.jvmArgs == null) {
            this.jvmArgs = new ArrayList<String>();
        }
        return this.jvmArgs;
    }

    public void singleInstance(boolean value) {
        this.setSingleInstance(value);
    }

    public void setSingleInstance(boolean singleInstance) {
        this.singleInstance = singleInstance;
    }

    public boolean isSingleInstance() {
        return this.singleInstance;
    }

    public void properties(Map<String, Object> map) {
        this.setProperties(map);
    }

    public void setProperties(Map<String, Object> map) {
        map.forEach((k, v) -> this.getProperties().put((String)k, v instanceof File ? ((File)v).getAbsolutePath() : (String)v));
    }

    public void property(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void property(String key, File value) {
        this.getProperties().put(key, value.getAbsolutePath());
    }

    public Map<String, String> getProperties() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void ideaModule(String value) {
        this.setIdeaModule(value);
    }

    public void setIdeaModule(String value) {
        this.ideaModule = value;
    }

    public String getIdeaModule() {
        return this.ideaModule;
    }

    public void workingDirectory(String value) {
        this.setWorkingDirectory(value);
    }

    public void setWorkingDirectory(String value) {
        this.workDir = value;
    }

    public String getWorkingDirectory() {
        return this.workDir;
    }

    public void source(SourceSet value) {
        this.getSources().add(value);
    }

    public void setSources(List<SourceSet> value) {
        this.sources = value;
    }

    public List<SourceSet> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceSet>();
        }
        return this.sources;
    }

    private List<File> getSourceDirs() {
        ArrayList<File> ret = new ArrayList<File>();
        this.getSources().forEach(set -> {
            ret.add(set.getOutput().getResourcesDir());
            ret.addAll(set.getOutput().getClassesDirs().getFiles());
            ret.addAll(set.getOutput().getDirs().getFiles());
        });
        return ret;
    }

    public void merge(RunConfig other, boolean overwrite, Map<String, String> vars) {
        vars.put("source_roots", Joiner.on((String)File.pathSeparator).join(this.getSourceDirs()));
        this.singleInstance = other.singleInstance;
        if (overwrite) {
            this.args = other.args == null ? this.args : other.args;
            this.main = other.main == null ? this.main : other.main;
            this.workDir = other.workDir == null ? this.workDir : other.workDir;
            String string = this.ideaModule = other.ideaModule == null ? this.ideaModule : other.ideaModule;
            if (other.env != null) {
                other.env.forEach((k, v) -> this.getEnvironment().put((String)k, this.replace(vars, (String)v)));
            }
            if (other.props != null) {
                other.props.forEach((k, v) -> this.getProperties().put((String)k, this.replace(vars, (String)v)));
            }
        } else {
            this.args = other.args == null || this.args != null ? this.args : other.args;
            this.main = other.main == null || this.main != null ? this.main : other.main;
            this.workDir = other.workDir == null || this.workDir != null ? this.workDir : other.workDir;
            String string = this.ideaModule = other.ideaModule == null || this.ideaModule != null ? this.ideaModule : other.ideaModule;
            if (other.env != null) {
                other.env.forEach((k, v) -> this.getEnvironment().putIfAbsent((String)k, this.replace(vars, (String)v)));
            }
            if (other.props != null) {
                other.props.forEach((k, v) -> this.getProperties().putIfAbsent((String)k, this.replace(vars, (String)v)));
            }
        }
    }

    private String replace(Map<String, String> vars, String value) {
        if (value == null || value.length() <= 2 || value.charAt(0) != '{' || value.charAt(value.length() - 1) != '}') {
            return value;
        }
        String key = value.substring(1, value.length() - 1);
        String resolved = vars.get(key);
        return resolved == null ? value : resolved;
    }

    public boolean isClient() {
        boolean isTargetClient = this.getEnvironment().getOrDefault("target", "").contains("client");
        return isTargetClient || MCP_CLIENT_MAIN.equals(this.getMain()) || MC_CLIENT_MAIN.equals(this.getMain());
    }

    public static class Container {
        private Map<String, RunConfig> runs = new HashMap<String, RunConfig>();

        public void methodMissing(String name, Object value) {
            this.propertyMissing(name, value);
        }

        public Object propertyMissing(String name) {
            if (!this.runs.containsKey(name)) {
                throw new MissingPropertyException(name);
            }
            return this.runs.get(name);
        }

        public void propertyMissing(String name, Object value) {
            if (!(value instanceof Closure)) {
                throw new IllegalArgumentException("Argument must be Closure");
            }
            Closure closure = (Closure)value;
            RunConfig run = new RunConfig();
            closure.setResolveStrategy(1);
            closure.setDelegate((Object)run);
            closure.call();
            this.runs.put(name, run);
        }

        public Map<String, RunConfig> getRuns() {
            return this.runs;
        }
    }
}

