/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Locale;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class Artifact
implements ArtifactIdentifier,
Comparable<Artifact> {
    private String group;
    private String name;
    private String version;
    private String classifier = null;
    private String ext = "jar";
    private String path;
    private String file;
    private String descriptor;
    private ComparableVersion comp;
    private boolean isSnapshot = false;

    public static Artifact from(String descriptor) {
        Artifact ret = new Artifact();
        ret.descriptor = descriptor;
        String[] pts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').split((CharSequence)descriptor), String.class);
        ret.group = pts[0];
        ret.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ret.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        ret.version = pts[2];
        ret.comp = new ComparableVersion(ret.version);
        ret.isSnapshot = ret.version.toLowerCase(Locale.ENGLISH).endsWith("-snapshot");
        if (pts.length > 3) {
            ret.classifier = pts[3];
        }
        ret.file = ret.name + '-' + ret.version;
        if (ret.classifier != null) {
            ret.file = ret.file + '-' + ret.classifier;
        }
        ret.file = ret.file + '.' + ret.ext;
        ret.path = ret.group.replace('.', '/') + '/' + ret.name + '/' + ret.version + '/' + ret.file;
        return ret;
    }

    public static Artifact from(String group, String name, String version, String classifier, String ext) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(':').append(name).append(':').append(version);
        if (classifier != null) {
            buf.append(':').append(classifier);
        }
        if (ext != null && !"jar".equals(ext)) {
            buf.append('@').append(ext);
        }
        return Artifact.from(buf.toString());
    }

    public File getLocalPath(File base) {
        return new File(base, this.path.replace('/', File.separatorChar));
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        return this.file;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public String toString() {
        return this.getDescriptor();
    }

    @Override
    public int compareTo(Artifact o) {
        int ret = 0;
        ret = this.group.compareTo(o.group);
        if (ret != 0) {
            return ret;
        }
        ret = this.name.compareTo(o.name);
        if (ret != 0) {
            return ret;
        }
        ret = this.comp.compareTo(o.comp);
        if (ret != 0) {
            return ret;
        }
        if (this.isSnapshot) {
            // empty if block
        }
        if ((ret = this.classifier.compareTo(o.classifier)) != 0) {
            return ret;
        }
        return this.ext.compareTo(o.ext);
    }
}

