/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import com.amadornes.artifactural.gradle.GradleRepositoryAdapter;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.ManifestJson;
import net.minecraftforge.gradle.common.util.MappingFile;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.gradle.mcp.util.MCPWrapper;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.logging.Logger;

public class MCPRepo
extends BaseRepo {
    private static MCPRepo INSTANCE = null;
    private static final String GROUP_MINECRAFT = "net.minecraft";
    private static final String NAMES_MINECRAFT = "^(client|server|joined)$";
    private static final String GROUP_MCP = "de.oceanlabs.mcp";
    private static final String NAMES_MCP = "^(mcp_config)$";
    private static final String STEP_MERGE = "merge";
    private static final String STEP_RENAME = "rename";
    private final Project project;
    private final Repository repo;
    private final Map<String, MCPWrapper> wrappers = Maps.newHashMap();
    private final Map<String, McpNames> mapCache = new HashMap<String, McpNames>();

    private MCPRepo(Project project, File cache, Logger log) {
        super(cache, log);
        this.project = project;
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).provide((ArtifactProvider)this));
    }

    private static MCPRepo getInstance(Project project) {
        if (INSTANCE == null) {
            INSTANCE = new MCPRepo(project, Utils.getCache(project, "mcp_repo"), project.getLogger());
        }
        return INSTANCE;
    }

    public static void attach(Project project) {
        MCPRepo instance = MCPRepo.getInstance(project);
        GradleRepositoryAdapter.add((RepositoryHandler)project.getRepositories(), (String)"MCP_DYNAMIC", (File)instance.getCacheRoot(), (Repository)instance.repo);
    }

    public static ArtifactProvider<ArtifactIdentifier> create(Project project) {
        return MCPRepo.getInstance(project);
    }

    private File cacheMC(String side, String version, String classifier, String ext) {
        if (classifier != null) {
            return this.cache("net", "minecraft", side, version, side + '-' + version + '-' + classifier + '.' + ext);
        }
        return this.cache("net", "minecraft", side, version, side + '-' + version + '.' + ext);
    }

    private File cacheMCP(String version, String classifier, String ext) {
        if (classifier != null) {
            return this.cache("de", "oceanlabs", "mcp", "mcp_config", version, "mcp_config-" + version + '-' + classifier + '.' + ext);
        }
        return this.cache("de", "oceanlabs", "mcp", "mcp_config", version, "mcp_config-" + version + '.' + ext);
    }

    private File cacheMCP(String version) {
        return this.cache("de", "oceanlabs", "mcp", "mcp_config", version);
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String name = artifact.getName();
        String group = artifact.getGroup();
        if (group.equals(GROUP_MCP)) {
            if (!name.matches(NAMES_MCP)) {
                return null;
            }
        } else if (group.equals(GROUP_MINECRAFT)) {
            if (!name.matches(NAMES_MINECRAFT)) {
                return null;
            }
        } else {
            return null;
        }
        String version = artifact.getVersion();
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension();
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + name + ":" + version + ":" + classifier + "@" + ext);
        if (group.equals(GROUP_MINECRAFT)) {
            if ("pom".equals(ext)) {
                return this.findPom(name, version);
            }
            switch (classifier) {
                case "": {
                    return this.findRaw(name, version);
                }
                case "srg": {
                    return this.findSrg(name, version);
                }
            }
        } else if (group.equals(GROUP_MCP)) {
            // empty if block
        }
        return null;
    }

    private HashStore commonHash(File mcp) {
        return new HashStore(this.getCacheRoot()).add("mcp", mcp);
    }

    private File getMCP(String version) throws IOException {
        return Utils.downloadMaven(this.project, Artifact.from("de.oceanlabs.mcp:mcp_config:" + version + "@zip"), false);
    }

    private String getMCVersion(String version) {
        int idx = version.indexOf(45);
        if (idx != -1) {
            return version.substring(0, idx);
        }
        return version;
    }

    private File findVersion(String version) throws IOException {
        File manifest = this.cache("versions", "manifest.json");
        if (!Utils.downloadEtag(new URL("https://launchermeta.mojang.com/mc/game/version_manifest.json"), manifest)) {
            return null;
        }
        Utils.updateHash(manifest);
        File json = this.cache("versions", version, "version.json");
        URL url = Utils.loadJson(manifest, ManifestJson.class).getUrl(version);
        if (url == null) {
            throw new RuntimeException("Missing version from manifest: " + version);
        }
        if (!Utils.downloadEtag(url, json)) {
            return null;
        }
        Utils.updateHash(json);
        return json;
    }

    private File findPom(String side, String version) throws IOException {
        File json = this.findVersion(this.getMCVersion(version));
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File pom = this.cacheMC(side, version, null, "pom");
        this.debug("    Finding pom: " + pom);
        HashStore cache = this.commonHash(mcp).load(this.cacheMC(side, version, null, "pom.input"));
        if (!"server".equals(side)) {
            cache.add("json", json);
        }
        if (!cache.isSame() || !pom.exists()) {
            POMBuilder builder = new POMBuilder(GROUP_MINECRAFT, side, version);
            if (!"server".equals(side)) {
                VersionJson meta = Utils.loadJson(json, VersionJson.class);
                for (VersionJson.Library lib : meta.libraries) {
                    builder.dependencies().add(lib.name, "compile");
                    if (lib.downloads.classifiers == null) continue;
                    if (lib.downloads.classifiers.containsKey("test")) {
                        builder.dependencies().add(lib.name, "test").withClassifier("test");
                    }
                    if (lib.natives == null || !lib.natives.containsKey(MinecraftRepo.CURRENT_OS) || lib.getArtifact().getName().contains("java-objc-bridge")) continue;
                    builder.dependencies().add(lib.name, "runtime").withClassifier(lib.natives.get(MinecraftRepo.CURRENT_OS));
                }
                builder.dependencies().add("net.minecraft:client:" + this.getMCVersion(version), "compile").withClassifier("extra");
                builder.dependencies().add("net.minecraft:client:" + this.getMCVersion(version), "compile").withClassifier("data");
            } else {
                builder.dependencies().add("net.minecraft:server:" + this.getMCVersion(version), "compile").withClassifier("extra");
                builder.dependencies().add("net.minecraft:server:" + this.getMCVersion(version), "compile").withClassifier("data");
            }
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            wrapper.getConfig().getLibraries(side).forEach(e -> builder.dependencies().add((String)e, "compile"));
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private File findRaw(String side, String version) throws IOException {
        if (!"joined".equals(side)) {
            return null;
        }
        return this.findStepOutput(side, version, null, "jar", STEP_MERGE);
    }

    private File findSrg(String side, String version) throws IOException {
        return this.findStepOutput(side, version, "srg", "jar", STEP_RENAME);
    }

    private File findStepOutput(String side, String version, String classifier, String ext, String step) throws IOException {
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File raw = this.cacheMC(side, version, classifier, ext);
        this.debug("  Finding " + step + ": " + raw);
        HashStore cache = this.commonHash(mcp).load(this.cacheMC(side, version, classifier, ext + ".input"));
        if (!cache.isSame() || !raw.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            MCPRuntime runtime = wrapper.getRuntime(this.project, side);
            try {
                File output = runtime.execute(this.log, step);
                FileUtils.copyFile((File)output, (File)raw);
                cache.save();
                Utils.updateHash(raw, HashFunction.SHA1);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.lifecycle(e.getMessage());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return raw;
    }

    private synchronized MCPWrapper getWrapper(String version, File data) throws IOException {
        String hash = HashFunction.SHA1.hash(data);
        MCPWrapper ret = this.wrappers.get(version);
        if (ret == null || !hash.equals(ret.getHash())) {
            ret = new MCPWrapper(hash, data, this.cacheMCP(version));
            this.wrappers.put(version, ret);
        }
        return ret;
    }

    private File findRenames(String classifier, MappingFile.Format format, String version, boolean toObf) throws IOException {
        String ext = format.name().toLowerCase();
        File mcp = this.getMCP(version);
        if (mcp == null) {
            return null;
        }
        File file = this.cacheMCP(version, classifier, ext);
        this.debug("    Finding Renames: " + file);
        HashStore cache = this.commonHash(mcp).load(this.cacheMCP(version, classifier, ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            byte[] data = wrapper.getData("mappings");
            MappingFile obf_to_srg = MappingFile.load(new ByteArrayInputStream(data));
            obf_to_srg.write(format, file, toObf);
            cache.save();
            Utils.updateHash(file, HashFunction.SHA1);
        }
        return file;
    }

    private File findNames(String mapping) throws IOException {
        int idx = mapping.lastIndexOf(95);
        if (idx == -1) {
            return null;
        }
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = "de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip";
        this.debug("    Mapping: " + desc);
        return Utils.downloadMaven(this.project, Artifact.from(desc), false);
    }

    private McpNames loadMCPNames(String name, File data) throws IOException {
        McpNames map = this.mapCache.get(name);
        String hash = HashFunction.SHA1.hash(data);
        if (map == null || !hash.equals(map.hash)) {
            map = McpNames.load(data);
            this.mapCache.put(name, map);
        }
        return map;
    }

    private File findRenames(String classifier, MappingFile.Format format, String version, String mapping, boolean obf, boolean reverse) throws IOException {
        String ext = format.name().toLowerCase();
        File names = this.findNames(version);
        File mcp = this.getMCP(version);
        if (mcp == null || names == null) {
            return null;
        }
        File file = this.cacheMCP(version, classifier, ext);
        this.debug("    Finding Renames: " + file);
        HashStore cache = this.commonHash(mcp).load(this.cacheMCP(version, classifier, ext + ".input"));
        if (!cache.isSame() || !file.exists()) {
            MCPWrapper wrapper = this.getWrapper(version, mcp);
            byte[] data = wrapper.getData("mappings");
            MappingFile obf_to_srg = MappingFile.load(new ByteArrayInputStream(data));
            McpNames mcp_names = this.loadMCPNames(mapping, names);
            MappingFile ret = new MappingFile();
            if (obf) {
                obf_to_srg.getPackages().forEach(e -> ret.addPackage(e.getOriginal(), e.getMapped()));
                obf_to_srg.getClasses().forEach(cls -> {
                    ret.addClass(cls.getOriginal(), cls.getMapped());
                    MappingFile.Cls _cls = ret.getClass(cls.getOriginal());
                    cls.getFields().forEach(fld -> _cls.addField(fld.getOriginal(), mcp_names.rename(fld.getMapped())));
                    cls.getMethods().forEach(mtd -> _cls.addMethod(mtd.getOriginal(), mtd.getDescriptor(), mcp_names.rename(mtd.getMapped())));
                });
            } else {
                obf_to_srg.getPackages().forEach(e -> ret.addPackage(e.getMapped(), e.getMapped()));
                obf_to_srg.getClasses().forEach(cls -> {
                    ret.addClass(cls.getMapped(), cls.getMapped());
                    MappingFile.Cls _cls = ret.getClass(cls.getMapped());
                    cls.getFields().forEach(fld -> _cls.addField(fld.getMapped(), mcp_names.rename(fld.getMapped())));
                    cls.getMethods().forEach(mtd -> _cls.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mcp_names.rename(mtd.getMapped())));
                });
            }
            ret.write(format, file, reverse);
            cache.save();
            Utils.updateHash(file, HashFunction.SHA1);
        }
        return file;
    }
}

