/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.DownloadMCMeta;
import net.minecraftforge.gradle.common.task.DownloadMavenArtifact;
import net.minecraftforge.gradle.common.task.ExtractMCPData;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.EclipseHacks;
import net.minecraftforge.gradle.common.util.IntellijUtils;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.common.util.RunConfig;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.userdev.MinecraftUserRepo;
import net.minecraftforge.gradle.userdev.ModRemapingRepo;
import net.minecraftforge.gradle.userdev.UserDevExtension;
import net.minecraftforge.gradle.userdev.tasks.GenerateSRG;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class UserDevPlugin
implements Plugin<Project> {
    private static String MINECRAFT = "minecraft";
    private static String DEOBF = "deobf";

    public void apply(final @Nonnull Project project) {
        Logger logger = project.getLogger();
        UserDevExtension extension = (UserDevExtension)project.getExtensions().create("minecraft", UserDevExtension.class, new Object[]{project});
        if (project.getPluginManager().findPlugin("java") == null) {
            project.getPluginManager().apply("java");
        }
        File natives_folder = project.file((Object)"build/natives/");
        NamedDomainObjectContainer reobf = project.container(RenameJarInPlace.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<RenameJarInPlace>(){

            public RenameJarInPlace create(String jarName) {
                String name = Character.toUpperCase(jarName.charAt(0)) + jarName.substring(1);
                JavaPluginConvention java = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
                RenameJarInPlace task = (RenameJarInPlace)((Object)project.getTasks().maybeCreate("reobf" + name, RenameJarInPlace.class));
                task.setClasspath(((SourceSet)java.getSourceSets().getByName("main")).getCompileClasspath());
                project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
                project.afterEvaluate(p -> {
                    Task jar = project.getTasks().getByName(jarName);
                    if (!(jar instanceof Jar)) {
                        throw new IllegalStateException(jarName + "  is not a jar task. Can only reobf jars!");
                    }
                    task.setInput(((Jar)jar).getArchivePath());
                    task.dependsOn(new Object[]{jar});
                });
                return task;
            }
        });
        project.getExtensions().add("reobf", (Object)reobf);
        Configuration minecraft = (Configuration)project.getConfigurations().maybeCreate(MINECRAFT);
        Configuration compile = (Configuration)project.getConfigurations().maybeCreate("compile");
        Configuration deobf = (Configuration)project.getConfigurations().maybeCreate(DEOBF);
        compile.extendsFrom(new Configuration[]{minecraft});
        compile.extendsFrom(new Configuration[]{deobf});
        TaskProvider downloadMcpConfig = project.getTasks().register("downloadMcpConfig", DownloadMavenArtifact.class);
        TaskProvider extractSrg = project.getTasks().register("extractSrg", ExtractMCPData.class);
        TaskProvider createMcpToSrg = project.getTasks().register("createMcpToSrg", GenerateSRG.class);
        TaskProvider downloadMCMeta = project.getTasks().register("downloadMCMeta", DownloadMCMeta.class);
        TaskProvider extractNatives = project.getTasks().register("extractNatives", ExtractNatives.class);
        TaskProvider downloadAssets = project.getTasks().register("downloadAssets", DownloadAssets.class);
        extractSrg.configure(task -> {
            task.dependsOn(new Object[]{downloadMcpConfig});
            task.setConfig(((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).getOutput());
        });
        createMcpToSrg.configure(task -> {
            task.setReverse(true);
            task.dependsOn(new Object[]{extractSrg});
            task.setSrg(((ExtractMCPData)((Object)((Object)extractSrg.get()))).getOutput());
            task.setMappings(extension.getMappings());
        });
        extractNatives.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
            task.setOutput(natives_folder);
        });
        downloadAssets.configure(task -> {
            task.dependsOn(new Object[]{downloadMCMeta.get()});
            task.setMeta(((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).getOutput());
        });
        project.afterEvaluate(p -> {
            String newDep;
            MinecraftUserRepo mcrepo = null;
            ModRemapingRepo deobfrepo = null;
            DependencySet deps = minecraft.getDependencies();
            for (Dependency dep : deps.stream().collect(Collectors.toList())) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException("minecraft dependency must be a maven dependency.");
                }
                if (mcrepo != null) {
                    throw new IllegalArgumentException("Only allows one minecraft dependancy.");
                }
                deps.remove((Object)dep);
                mcrepo = new MinecraftUserRepo((Project)p, dep.getGroup(), dep.getName(), dep.getVersion(), extension.getAccessTransformers(), extension.getMappings());
                newDep = mcrepo.getDependencyString();
                p.getLogger().lifecycle("New Dep: " + newDep);
                ExternalModuleDependency ext = (ExternalModuleDependency)p.getDependencies().create((Object)newDep);
                ext.setChanging(true);
                minecraft.resolutionStrategy(strat -> strat.cacheChangingModulesFor(0, TimeUnit.MINUTES));
                minecraft.getDependencies().add((Object)ext);
            }
            deps = deobf.getDependencies();
            for (Dependency dep : deps.stream().collect(Collectors.toList())) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException("deobf dependency must be a maven dependency. File deps are on the TODO");
                }
                deps.remove((Object)dep);
                if (deobfrepo == null) {
                    deobfrepo = new ModRemapingRepo((Project)p, extension.getMappings());
                }
                newDep = deobfrepo.addDep(dep.getGroup(), dep.getName(), dep.getVersion());
                deobf.getDependencies().add((Object)p.getDependencies().create((Object)newDep));
            }
            new BaseRepo.Builder().add(mcrepo).add(deobfrepo).add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
            project.getRepositories().maven(e -> e.setUrl((Object)"http://files.minecraftforge.net/maven/"));
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(src -> src.artifact());
            });
            project.getRepositories().mavenCentral();
            if (mcrepo == null) {
                throw new IllegalStateException("Missing 'minecraft' dependency entry.");
            }
            mcrepo.validate();
            String mcVer = (String)project.getExtensions().getExtraProperties().get("MC_VERSION");
            String mcpVer = (String)project.getExtensions().getExtraProperties().get("MCP_VERSION");
            ((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).setArtifact("de.oceanlabs.mcp:mcp_config:" + mcpVer + "@zip");
            ((DownloadMCMeta)((Object)((Object)downloadMCMeta.get()))).setMCVersion(mcVer);
            RenameJarInPlace reobfJar = (RenameJarInPlace)((Object)((Object)reobf.create("jar")));
            reobfJar.dependsOn(new Object[]{createMcpToSrg});
            reobfJar.setMappings(((GenerateSRG)((Object)((Object)createMcpToSrg.get()))).getOutput());
            this.createRunConfigsTasks(project, (ExtractNatives)((Object)((Object)extractNatives.get())), (DownloadAssets)((Object)((Object)downloadAssets.get())), extension.getRunConfigs());
        });
    }

    private void createRunConfigsTasks(@Nonnull Project project, ExtractNatives extractNatives, DownloadAssets downloadAssets, List<RunConfig> runs) {
        TaskProvider prepareRun = project.getTasks().register("prepareRun", Task.class);
        prepareRun.configure(task -> task.dependsOn(new Object[]{project.getTasks().getByName("classes"), extractNatives, downloadAssets}));
        runs.forEach(runConfig -> {
            String taskName = runConfig.getName().replaceAll("[^a-zA-Z0-9\\-_]", "");
            if (!taskName.startsWith("run")) {
                taskName = "run" + taskName.substring(0, 1).toUpperCase() + taskName.substring(1);
            }
            TaskProvider runTask = project.getTasks().register(taskName, JavaExec.class);
            runTask.configure(task -> {
                task.dependsOn(new Object[]{prepareRun.get()});
                task.setMain(runConfig.getMain());
                task.setArgs(runConfig.getArgs());
                task.setSystemProperties(runConfig.getProperties());
                task.setEnvironment(runConfig.getEnvironment());
                String workDir = runConfig.getWorkingDirectory();
                File file = new File(workDir);
                if (!file.exists()) {
                    file.mkdirs();
                }
                task.setWorkingDir((Object)workDir);
                JavaPluginConvention java = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
                task.setClasspath(((SourceSet)java.getSourceSets().getByName("main")).getRuntimeClasspath());
            });
        });
        EclipseHacks.doEclipseFixes(project, extractNatives, downloadAssets, runs);
        IntellijUtils.createIntellijRunsTask(project, extractNatives, downloadAssets, (Task)prepareRun.get(), runs);
    }
}

