/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;

public class UserDevExtension {
    private String mappings;
    private List<File> accessTransformers = new ArrayList<File>();
    private List<RunConfig> runConfigs = new ArrayList<RunConfig>();

    @Inject
    public UserDevExtension(Project project) {
    }

    public String getMappings() {
        return this.mappings;
    }

    public List<File> getAccessTransformers() {
        return this.accessTransformers;
    }

    public void mappings(Map<String, String> map) {
        String channel = map.get("channel");
        String version = map.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify mappings channel and version");
        }
        this.setMappings(channel + '_' + version);
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public void setAccessTransformers(List<File> files) {
        this.accessTransformers.clear();
        this.accessTransformers.addAll(files);
    }

    public void setAccessTransformer(File file) {
        this.accessTransformers.add(file);
    }

    public void setRunConfigs(List<RunConfig> runs) {
        this.runConfigs.clear();
        this.runConfigs.addAll(runs);
    }

    public void runConfig(RunConfig run) {
        this.runConfigs.add(run);
    }

    public void runConfig(Closure<? super RunConfig> action) {
        RunConfig run = new RunConfig();
        action.setResolveStrategy(1);
        action.setDelegate((Object)run);
        action.call();
        this.runConfigs.add(run);
    }

    public List<RunConfig> getRunConfigs() {
        return this.runConfigs;
    }
}

