/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.base.Strings;
import com.google.common.io.Files;
import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.Type;

public class TaskCreateExc
extends DefaultTask {
    private static Pattern CLS_ENTRY = Pattern.compile("L([^;]+);");
    private File srg;
    private File statics;
    private File constructors;
    private File mappings;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.exc"));

    @TaskAction
    public void run() throws IOException {
        HashSet staticMap = new HashSet(Files.readLines((File)this.getStatics(), (Charset)StandardCharsets.UTF_8));
        Map<String, String> names = this.loadMappings();
        ArrayList<String> out = new ArrayList<String>();
        List lines = Files.readLines((File)this.getSrg(), (Charset)StandardCharsets.UTF_8);
        lines = lines.stream().map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
        HashMap<String, String> classes = new HashMap<String, String>();
        lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> classes.put(pts[0], pts[1]));
        String currentClass = null;
        for (String line2 : lines) {
            String name;
            String[] pts2;
            if (line2.startsWith("\t")) {
                line2 = currentClass + " " + line2.substring(1);
            }
            if ((pts2 = line2.split(" "))[0].indexOf(58) != -1) {
                int idx;
                String name2;
                if (!pts2[0].equals("MD:") || !(name2 = pts2[3].substring((idx = pts2[3].lastIndexOf(47)) + 1)).startsWith("func_") || pts2[4].contains("()")) continue;
                out.add(pts2[3].substring(0, idx + 1) + "." + names.getOrDefault(name2, name2) + pts2[4] + "=|" + String.join((CharSequence)",", this.buildArgs(name2, pts2[4], staticMap.contains(name2))));
                continue;
            }
            if (pts2.length == 2) {
                currentClass = pts2[1];
                continue;
            }
            if (pts2.length != 4 || !(name = pts2[3]).startsWith("func_") || pts2[2].contains("()")) continue;
            String desc = this.remapDesc(pts2[2], classes);
            out.add(currentClass + "." + names.getOrDefault(name, name) + desc + "=|" + String.join((CharSequence)",", this.buildArgs(name, desc, staticMap.contains(name))));
        }
        Files.readLines((File)this.getConstructors(), (Charset)StandardCharsets.UTF_8).stream().map(l -> l.split(" ")).forEach(pts -> out.add(pts[1] + ".<init>" + pts[2] + "=|" + String.join((CharSequence)",", this.buildArgs(pts[0], pts[2], false))));
        try (FileOutputStream fos = new FileOutputStream(this.getOutput());){
            IOUtils.write((String)String.join((CharSequence)"\n", out), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
        }
    }

    private List<String> buildArgs(String name, String desc, boolean isStatic) {
        String prefix = "p_i" + name + "_";
        if (name.startsWith("func_")) {
            prefix = "p_" + name.split("_")[1] + "_";
        }
        ArrayList<String> ret = new ArrayList<String>();
        int idx = isStatic ? 0 : 1;
        for (Type arg : Type.getArgumentTypes((String)desc)) {
            ret.add(prefix + idx + '_');
            idx += arg.getSize();
        }
        return ret;
    }

    private String remapClass(String cls, Map<String, String> map) {
        String ret = map.get(cls);
        if (ret != null) {
            return ret;
        }
        int idx = cls.lastIndexOf(36);
        ret = idx != -1 ? this.remapClass(cls.substring(0, idx), map) + cls.substring(idx) : cls;
        map.put(cls, ret);
        return cls;
    }

    private String remapDesc(String desc, Map<String, String> map) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = CLS_ENTRY.matcher(desc);
        while (matcher.find()) {
            matcher.appendReplacement(buf, Matcher.quoteReplacement("L" + this.remapClass(matcher.group(1), map) + ";"));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private Map<String, String> loadMappings() throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(this.getMappings());){
            zip.stream().filter(e -> e.getName().equals("fields.csv") || e.getName().equals("methods.csv")).forEach(e -> {
                CsvReader reader = new CsvReader();
                reader.setContainsHeader(true);
                try {
                    CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream((ZipEntry)e)));
                    for (CsvRow row : csv.getRows()) {
                        names.put(row.getField("searge"), row.getField("name"));
                    }
                }
                catch (IOException e1) {
                    throw new RuntimeException(e1);
                }
            });
        }
        return names;
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @InputFile
    public File getStatics() {
        return this.statics;
    }

    public void setStatics(File value) {
        this.statics = value;
    }

    @InputFile
    public File getConstructors() {
        return this.constructors;
    }

    public void setConstructors(File value) {
        this.constructors = value;
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

