/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadMCPConfigTask
extends DefaultTask {
    private String config;
    private File output;

    @TaskAction
    public void downloadMCPConfig() throws IOException {
        File file = this.getConfigFile();
        if (this.getOutput().exists()) {
            if (FileUtils.contentEquals((File)file, (File)this.getOutput())) {
                this.setDidWork(false);
                return;
            }
            this.getOutput().delete();
        }
        FileUtils.copyFile((File)file, (File)this.getOutput());
        this.setDidWork(true);
    }

    public Object getConfig() {
        return this.config;
    }

    @InputFile
    private File getConfigFile() {
        return this.downloadConfigFile(this.config);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setConfig(String value) {
        this.config = value;
    }

    public void setOutput(File value) {
        this.output = value;
    }

    private File downloadConfigFile(String config) {
        return Utils.downloadMaven(this.getProject(), Artifact.from(config), false);
    }
}

