/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.gradle.GradleRepositoryAdapter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.gradle.common.util.Artifact;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;

public class MavenArtifactDownloader {
    private static final Cache<String, File> CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Map<Project, Integer> COUNTER = new HashMap<Project, Integer>();
    private static final Map<String, String> VERSIONS = new HashMap<String, String>();

    private static File _download(Project project, String artifact, boolean changing, boolean generated, boolean gradle) {
        File ret = null;
        try {
            ret = (File)CACHE.getIfPresent((Object)artifact);
            if (ret != null && !ret.exists()) {
                CACHE.invalidate((Object)artifact);
                ret = null;
            }
            if (ret == null && generated && (ret = MavenArtifactDownloader._generate(project, artifact)) != null) {
                CACHE.put((Object)artifact, (Object)ret);
            }
            if (ret == null && gradle && (ret = MavenArtifactDownloader._gradle(project, artifact, changing)) != null) {
                CACHE.put((Object)artifact, (Object)ret);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static File _generate(Project project, String artifact) {
        Artifact art = Artifact.from(artifact);
        RepositoryHandler repos = project.getRepositories();
        for (ArtifactRepository repo : repos) {
            GradleRepositoryAdapter fake;
            File ret;
            if (!(repo instanceof GradleRepositoryAdapter) || (ret = (fake = (GradleRepositoryAdapter)repo).getArtifact((ArtifactIdentifier)art)) == null || !ret.exists()) continue;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File _gradle(Project project, String artifact, boolean changing) {
        String name = "mavenDownloader_" + artifact.replace(':', '_');
        Project project2 = project;
        synchronized (project2) {
            int count = COUNTER.getOrDefault(project, 1);
            name = name + "_" + count++;
            COUNTER.put(project, count);
        }
        Artifact mine = Artifact.from(artifact);
        RepositoryHandler repos = project.getRepositories();
        ArrayList old = new ArrayList(repos);
        repos.removeIf(e -> e instanceof GradleRepositoryAdapter);
        Configuration cfg = (Configuration)project.getConfigurations().create(name);
        ExternalModuleDependency dependency = (ExternalModuleDependency)project.getDependencies().create((Object)artifact);
        dependency.setChanging(changing);
        cfg.getDependencies().add((Object)dependency);
        cfg.resolutionStrategy(strat -> {
            strat.cacheChangingModulesFor(5, TimeUnit.MINUTES);
            strat.cacheDynamicVersionsFor(5, TimeUnit.MINUTES);
        });
        Set files = null;
        try {
            files = cfg.resolve();
        }
        catch (NullPointerException npe) {
            project.getLogger().error("Failed to download " + artifact + " gradle exploded");
            return null;
        }
        File ret = (File)files.iterator().next();
        cfg.getResolvedConfiguration().getResolvedArtifacts().forEach(art -> {
            ModuleVersionIdentifier resolved = art.getModuleVersion().getId();
            if (resolved.getGroup().equals(mine.getGroup()) && resolved.getName().equals(mine.getName()) && (mine.getClassifier() == null && art.getClassifier() == null || mine.getClassifier().equals(art.getClassifier()))) {
                VERSIONS.put(artifact, resolved.getVersion());
            }
        });
        project.getConfigurations().remove((Object)cfg);
        repos.clear();
        repos.addAll(old);
        return ret;
    }

    public static File both(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, true, true);
    }

    public static String getVersion(Project project, String artifact) {
        MavenArtifactDownloader.gradle(project, artifact, true);
        return VERSIONS.get(artifact);
    }

    public static File gradle(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, false, true);
    }

    public static File generate(Project project, String artifact, boolean changing) {
        return MavenArtifactDownloader._download(project, artifact, changing, true, false);
    }
}

