/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadAssets
extends DefaultTask {
    private static final String RESOURCE_REPO = "http://resources.download.minecraft.net/";
    private File meta;

    @TaskAction
    public void run() throws IOException {
        AssetIndex index = Utils.loadJson(this.getIndex(), AssetIndex.class);
        ArrayList<String> keys = new ArrayList<String>(index.objects.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Asset asset = index.objects.get(key);
            File target = Utils.getCache(this.getProject(), "assets/objects/", asset.getPath());
            if (target.exists()) continue;
            URL url = new URL(RESOURCE_REPO + asset.getPath());
            this.getProject().getLogger().lifecycle("Downloading: " + url + " Asset: " + key);
            FileUtils.copyURLToFile((URL)url, (File)target);
        }
    }

    private File getIndex() throws IOException {
        VersionJson json = Utils.loadJson(this.getMeta(), VersionJson.class);
        File target = Utils.getCache(this.getProject(), "assets/indexes/" + json.assetIndex.id + ".json");
        return Utils.updateDownload(this.getProject(), target, json.assetIndex);
    }

    @InputFile
    public File getMeta() {
        return this.meta;
    }

    public void setMeta(File value) {
        this.meta = value;
    }

    public File getOutput() {
        return Utils.getCache(this.getProject(), "assets/");
    }

    private static class Asset {
        String hash;

        private Asset() {
        }

        public String getPath() {
            return this.hash.substring(0, 2) + '/' + this.hash;
        }
    }

    private static class AssetIndex {
        Map<String, Asset> objects;

        private AssetIndex() {
        }
    }
}

