/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;

public class RenameJar
extends JarExec {
    private File input;
    private File output;
    private File mappings;

    public RenameJar() {
        this.tool = "net.md-5:SpecialSource:1.8.3:shaded";
        this.args = new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{mappings}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{mappings}", this.getMappings().getAbsolutePath());
        return Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

