/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.MCPExtension;
import net.minecraftforge.gradle.patcher.PatcherExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskGenerateUserdevConfig
extends DefaultTask {
    private Set<File> ats = new TreeSet<File>();
    private Set<File> srgs = new TreeSet<File>();
    private List<String> srgLines = new ArrayList<String>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.json"));
    private String universal;
    private String source;
    private String tool;
    private String[] args;
    private List<String> libraries;

    @TaskAction
    public void apply() throws IOException {
        UserdevConfigV1 json = new UserdevConfigV1();
        json.spec = 1;
        json.binpatches = "joined.lzma";
        json.sources = this.source;
        json.universal = this.universal;
        json.patches = "patches/";
        if (this.libraries != null && !this.libraries.isEmpty()) {
            this.libraries.forEach(json::addLibrary);
        }
        this.getATs().forEach(at -> json.addAT("ats/" + at.getName()));
        this.getSRGs().forEach(srg -> json.addSRG("srgs/" + srg.getName()));
        this.getSRGLines().forEach(srg -> json.addSRGLine((String)srg));
        this.addParent(json, this.getProject());
        json.binpatcher = new MCPConfigV1.Function();
        json.binpatcher.setVersion(this.getTool());
        json.binpatcher.setArgs(Arrays.asList(this.args));
        Files.write((byte[])Utils.GSON.toJson((Object)json).getBytes(StandardCharsets.UTF_8), (File)this.getOutput());
    }

    private void addParent(UserdevConfigV1 json, Project project) {
        PatcherExtension patcher = (PatcherExtension)project.getExtensions().findByType(PatcherExtension.class);
        MCPExtension mcp = (MCPExtension)project.getExtensions().findByType(MCPExtension.class);
        if (patcher != null) {
            if (project != this.getProject() && patcher.patches != null && json.parent == null) {
                json.parent = String.format("%s:%s:%s:userdev", project.getGroup(), project.getName(), project.getVersion());
                return;
            }
            if (patcher.parent != null) {
                this.addParent(json, patcher.parent);
            }
        } else if (json.parent == null) {
            if (mcp == null) {
                throw new IllegalStateException("Could not determine MCP parent for userdev config");
            }
            json.mcp = mcp.getConfig().toString();
        }
    }

    @Input
    public List<String> getLibraries() {
        return this.libraries == null ? Collections.emptyList() : this.libraries;
    }

    public void setLibrary(String value) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<String>();
        }
        this.libraries.add(value);
    }

    public void addLibrary(String value) {
        this.setLibrary(value);
    }

    @Input
    public String getUniversal() {
        return this.universal;
    }

    public void setUniversal(String value) {
        this.universal = value;
    }

    @Input
    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    @Input
    public String getTool() {
        return this.tool;
    }

    public void setTool(String value) {
        this.tool = value;
    }

    @Input
    public String[] getArguments() {
        return this.args == null ? new String[]{} : this.args;
    }

    public void setArguments(String ... value) {
        this.args = value;
    }

    @Input
    public Set<File> getATs() {
        return this.ats;
    }

    public void addAT(File value) {
        this.ats.add(value);
    }

    @Input
    public Set<File> getSRGs() {
        return this.srgs;
    }

    public void addSRG(File value) {
        this.srgs.add(value);
    }

    @Input
    public List<String> getSRGLines() {
        return this.srgLines;
    }

    public void addSRGLine(String value) {
        this.srgLines.add(value);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

