/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import joptsimple.internal.Strings;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskFilterNewJar
extends DefaultTask {
    private File input;
    private File srg;
    private Set<File> blacklist = new HashSet<File>();
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.jar"));

    @TaskAction
    public void apply() throws IOException {
        Throwable throwable;
        HashSet filter = new HashSet();
        for (File file : this.getBlacklist()) {
            ZipFile zip = new ZipFile(file);
            throwable = null;
            try {
                Utils.forZip(zip, entry -> filter.add(entry.getName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (zip == null) continue;
                if (throwable != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                zip.close();
            }
        }
        HashSet classes = new HashSet();
        List lines = Files.readLines((File)this.getSrg(), (Charset)StandardCharsets.UTF_8).stream().map(line -> line.split("#")[0]).filter(l -> !Strings.isNullOrEmpty((String)l.trim())).collect(Collectors.toList());
        lines.stream().filter(line -> !line.startsWith("\t") || line.indexOf(58) != -1 && line.startsWith("CL:")).map(line -> line.indexOf(58) != -1 ? line.substring(4).split(" ") : line.split(" ")).filter(pts -> ((String[])pts).length == 2 && !pts[0].endsWith("/")).forEach(pts -> classes.add(pts[1]));
        throwable = null;
        try (ZipFile zin = new ZipFile(this.getInput());
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.getOutput()));){
            Utils.forZip(zin, entry -> {
                if (entry.isDirectory() || filter.contains(entry.getName()) || entry.getName().endsWith(".class") && this.isVanilla(classes, entry.getName().substring(0, entry.getName().length() - 6))) {
                    return;
                }
                ZipEntry nentry = new ZipEntry(entry.getName());
                nentry.setTime(0L);
                out.putNextEntry(nentry);
                IOUtils.copy((InputStream)zin.getInputStream((ZipEntry)entry), (OutputStream)out);
                out.closeEntry();
            });
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
    }

    private boolean isVanilla(Set<String> classes, String cls) {
        int idx = cls.indexOf(36);
        if (idx != -1) {
            return this.isVanilla(classes, cls.substring(0, idx));
        }
        return classes.contains(cls);
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }

    @InputFile
    public File getSrg() {
        return this.srg;
    }

    public void setSrg(File value) {
        this.srg = value;
    }

    @InputFiles
    public Set<File> getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Set<File> value) {
        this.blacklist = value;
    }

    public void addBlacklist(Collection<File> values) {
        this.blacklist.addAll(values);
    }

    public void addBlacklist(File ... values) {
        for (File value : values) {
            this.blacklist.add(value);
        }
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

