/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.gradle.api.Project;

public class PatcherExtension {
    public Project parent;
    public File cleanSrc;
    public File patchedSrc;
    public File patches;
    public String mcVersion;
    public boolean srgPatches = true;
    private String mappings;
    private List<Object> extraMappings = new ArrayList<Object>();
    private List<Object> extraExcs = new ArrayList<Object>();
    private List<File> accessTransformers = new ArrayList<File>();
    private List<File> excs = new ArrayList<File>();
    private RunConfig clientRun = new RunConfig();
    private RunConfig serverRun = new RunConfig();

    @Inject
    public PatcherExtension(Project project) {
    }

    public String getMappings() {
        return this.mappings;
    }

    public List<Object> getExtraMappings() {
        return this.extraMappings;
    }

    public List<Object> getExtraExcs() {
        return this.extraExcs;
    }

    public List<File> getAccessTransformers() {
        return this.accessTransformers;
    }

    public List<File> getExcs() {
        return this.excs;
    }

    public void mappings(Map<String, String> map) {
        String channel = map.get("channel");
        String version = map.get("version");
        if (channel == null || version == null) {
            throw new IllegalArgumentException("Must specify mappings channel and version");
        }
        if (!version.contains("-")) {
            version = version + "-+";
        }
        this.setMappings("de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip");
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public void extraMapping(Object mapping) {
        if (!(mapping instanceof String) && !(mapping instanceof File)) {
            throw new IllegalArgumentException("Extra mappings must be a file or a string!");
        }
        this.extraMappings.add(mapping);
    }

    public void extraExc(Object exc) {
        this.extraExcs.add(exc);
    }

    void copyFrom(PatcherExtension other) {
        if (this.mappings == null) {
            this.setMappings(other.getMappings());
        }
        if (this.mcVersion == null) {
            this.mcVersion = other.mcVersion;
        }
    }

    public void setAccessTransformers(List<File> files) {
        this.accessTransformers.clear();
        this.accessTransformers.addAll(files);
    }

    public void setAccessTransformer(File file) {
        this.accessTransformers.add(file);
    }

    public void setExc(List<File> files) {
        this.excs.clear();
        this.excs.addAll(files);
    }

    public void setExc(File file) {
        this.excs.add(file);
    }

    public void setClientRun(Closure<? super RunConfig> action) {
        action.setResolveStrategy(1);
        action.setDelegate((Object)this.clientRun);
        action.call();
    }

    public RunConfig getClientRun() {
        return this.clientRun;
    }

    public void setServerRun(Closure<? super RunConfig> action) {
        action.setResolveStrategy(1);
        action.setDelegate((Object)this.serverRun);
        action.call();
    }

    public RunConfig getServerRun() {
        return this.serverRun;
    }
}

