/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.util.McpNames;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class SrgJarRenamer {
    public static boolean rename(File input, File output, File names) throws IOException {
        if (input == null || !input.exists()) {
            throw new IllegalArgumentException("Invalid input: " + input);
        }
        if (output == null) {
            output = input;
        }
        if (names == null || !names.exists()) {
            throw new IllegalArgumentException("Invalid names file: " + names);
        }
        McpNames map = McpNames.load(names);
        if (!output.getParentFile().exists()) {
            output.getParentFile().mkdirs();
        }
        ByteArrayOutputStream memory = input.equals(output) ? new ByteArrayOutputStream() : null;
        try (ZipOutputStream zout = new ZipOutputStream(memory == null ? new FileOutputStream(output) : memory);
             ZipInputStream zin = new ZipInputStream(new FileInputStream(input));){
            ZipEntry ein = null;
            while ((ein = zin.getNextEntry()) != null) {
                if (ein.getName().endsWith(".class")) {
                    byte[] data = SrgJarRenamer.rename(IOUtils.toByteArray((InputStream)zin), map);
                    ZipEntry eout = new ZipEntry(ein.getName());
                    eout.setTime(0L);
                    zout.putNextEntry(eout);
                    zout.write(data);
                    continue;
                }
                zout.putNextEntry(ein);
                IOUtils.copy((InputStream)zin, (OutputStream)zout);
            }
        }
        if (memory != null) {
            Files.write(output.toPath(), memory.toByteArray(), new OpenOption[0]);
        }
        return true;
    }

    private static byte[] rename(byte[] data, final McpNames map) {
        ClassReader reader = new ClassReader(data);
        ClassWriter writer = new ClassWriter(0);
        ClassRemapper remapper = new ClassRemapper((ClassVisitor)writer, new Remapper(){

            public String mapFieldName(String owner, String name, String descriptor) {
                return map.rename(name);
            }

            public String mapInvokeDynamicMethodName(String name, String descriptor) {
                return map.rename(name);
            }

            public String mapMethodName(String owner, String name, String descriptor) {
                return map.rename(name);
            }
        });
        reader.accept((ClassVisitor)remapper, 0);
        return writer.toByteArray();
    }
}

