/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import groovy.util.Node;
import groovy.util.XmlParser;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraftforge.gradle.common.task.DownloadAssets;
import net.minecraftforge.gradle.common.task.ExtractNatives;
import net.minecraftforge.gradle.common.util.RunConfig;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.plugins.ide.eclipse.GenerateEclipseClasspath;
import org.xml.sax.SAXException;

public class EclipseHacks {
    public static void doEclipseFixes(Project project, ExtractNatives nativesTask, DownloadAssets assetsTask, RunConfig clientRun, RunConfig serverRun) {
        File natives = nativesTask.getOutput();
        File assets = assetsTask.getOutput();
        String LIB_ATTR = "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY";
        project.getTasks().withType(GenerateEclipseClasspath.class, task -> {
            task.dependsOn(new Object[]{nativesTask, assetsTask});
            task.doFirst(t -> task.getClasspath().getSourceSets().forEach(s -> {
                if (s.getName().equals("main")) {
                    s.getAllSource().getSrcDirs().stream().filter(f -> !f.exists()).forEach(File::mkdirs);
                }
            }));
            task.doLast(t -> {
                try {
                    Node xml = new XmlParser().parse(task.getOutputFile());
                    ArrayList entries = (ArrayList)xml.get("classpathentry");
                    HashSet paths = new HashSet();
                    ArrayList remove = new ArrayList();
                    entries.stream().filter(e -> "src".equals(e.get("@kind"))).forEach(e -> {
                        Node attr;
                        if (!paths.add((String)e.get("@path"))) {
                            remove.add(e);
                        }
                        if (((List)e.get("attributes")).isEmpty()) {
                            e.appendNode((Object)"attributes");
                        }
                        if (((List)(attr = (Node)((List)e.get("attributes")).get(0)).get("attribute")).stream().noneMatch(n -> "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY".equals(n.get("@name")))) {
                            attr.appendNode((Object)"attribute", EclipseHacks.props("name", "org.eclipse.jdt.launching.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY", "value", natives.getAbsolutePath()));
                        }
                    });
                    remove.forEach(arg_0 -> ((Node)xml).remove(arg_0));
                    try (FileOutputStream fos = new FileOutputStream(task.getOutputFile());){
                        IOUtils.write((String)XmlUtil.serialize((Node)xml), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                    }
                    File run_dir = project.file((Object)"run");
                    if (!run_dir.exists()) {
                        run_dir.mkdirs();
                    }
                    String niceName = project.getName().substring(0, 1).toUpperCase() + project.getName().substring(1);
                    for (boolean client : new boolean[]{true, false}) {
                        xml = new Node(null, (Object)"launchConfiguration", EclipseHacks.props("type", "org.eclipse.jdt.launching.localJavaApplication"));
                        String main = client ? (clientRun.getMain() != null ? clientRun.getMain() : "mcp.client.Start") : (serverRun.getMain() != null ? serverRun.getMain() : "net.minecraft.server.MinecraftServer");
                        xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.MAIN_TYPE", "value", main));
                        xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.PROJECT_ATTR", "value", project.getName()));
                        xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.WORKING_DIRECTORY", "value", run_dir.getAbsolutePath()));
                        Node env = xml.appendNode((Object)"mapAttribute", EclipseHacks.props("key", "org.eclipse.debug.core.environmentVariables"));
                        env.appendNode((Object)"mapEntry", EclipseHacks.props("key", "assetDirectory", "value", assets.getAbsolutePath()));
                        (client ? clientRun : serverRun).getEnvironment().forEach((k, v) -> env.appendNode((Object)"mapEntry", EclipseHacks.props("key", k, "value", v)));
                        String props = (client ? clientRun : serverRun).getProperties().entrySet().stream().map(e -> {
                            String val = (String)e.getValue();
                            if (val.indexOf(32) != -1) {
                                val = "\"" + ((String)e.getValue()).replaceAll("\"", "\\\"") + "\"";
                            }
                            return "-D" + (String)e.getKey() + "=" + val;
                        }).collect(Collectors.joining("\n"));
                        if (!props.isEmpty()) {
                            xml.appendNode((Object)"stringAttribute", EclipseHacks.props("key", "org.eclipse.jdt.launching.VM_ARGUMENTS", "value", props));
                        }
                        try (FileOutputStream fos = new FileOutputStream(project.file((Object)(client ? "RunClient" + niceName + ".launch" : "RunServer" + niceName + ".launch")));){
                            IOUtils.write((String)XmlUtil.serialize((Node)xml), (OutputStream)fos, (Charset)StandardCharsets.UTF_8);
                        }
                    }
                }
                catch (IOException | ParserConfigurationException | SAXException e2) {
                    throw new RuntimeException(e2);
                }
            });
        });
    }

    private static Map<String, String> props(String ... data) {
        if (data.length % 2 != 0) {
            throw new IllegalArgumentException("Properties must be key,value pairs");
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        for (int x = 0; x < data.length; x += 2) {
            ret.put(data[x], data[x + 1]);
        }
        return ret;
    }
}

