/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public class JarExec
extends DefaultTask {
    private static final OutputStream NULL = new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    };
    protected boolean hasLog = true;
    protected String tool;
    private File _tool;
    protected String[] args;
    protected FileCollection classpath = null;

    @TaskAction
    public void apply() throws IOException {
        File jar = this.getToolJar();
        JarFile jarFile = new JarFile(jar);
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        jarFile.close();
        File workDir = this.getProject().file((Object)("build/" + this.getName()));
        if (!workDir.exists()) {
            workDir.mkdirs();
        }
        File logFile = new File(workDir, "log.txt");
        try (final OutputStream log = this.hasLog ? new BufferedOutputStream(new FileOutputStream(logFile)) : NULL;){
            JavaExec java = (JavaExec)this.getProject().getTasks().create("_", JavaExec.class);
            java.setArgs(this.filterArgs());
            if (this.getClasspath() == null) {
                java.setClasspath((FileCollection)this.getProject().files(new Object[]{jar}));
            } else {
                java.setClasspath((FileCollection)this.getProject().files(new Object[]{jar, this.getClasspath()}));
            }
            java.setWorkingDir(workDir);
            java.setMain(mainClass);
            java.setStandardOutput(new OutputStream(){

                @Override
                public void flush() throws IOException {
                    log.flush();
                }

                @Override
                public void close() {
                }

                @Override
                public void write(int b) throws IOException {
                    log.write(b);
                }
            });
            java.exec();
            this.getProject().getTasks().remove((Object)java);
        }
        if (this.hasLog) {
            this.postProcess(logFile);
        }
        if (workDir.list().length == 0) {
            workDir.delete();
        }
    }

    protected List<String> filterArgs() {
        return Arrays.asList(this.getArgs());
    }

    protected void postProcess(File log) {
    }

    public String getResolvedVersion() {
        return MavenArtifactDownloader.getVersion(this.getProject(), this.getTool());
    }

    @Input
    public boolean getHasLog() {
        return this.hasLog;
    }

    public void setHasLog(boolean value) {
        this.hasLog = value;
    }

    @InputFile
    public File getToolJar() {
        if (this._tool == null) {
            this._tool = MavenArtifactDownloader.gradle(this.getProject(), this.getTool(), false);
        }
        return this._tool;
    }

    @Input
    public String getTool() {
        return this.tool;
    }

    public void setTool(String value) {
        this.tool = value;
    }

    @Input
    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] value) {
        this.args = value;
    }

    public void setArgs(List<String> value) {
        this.setArgs(value.toArray(new String[value.size()]));
    }

    @Optional
    @InputFiles
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection value) {
        this.classpath = value;
    }
}

