/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.task;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Base64;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ArchiveChecksum
extends DefaultTask {
    private Supplier<File> input;
    private File output;

    @Input
    public File getInput() {
        return this.input.get();
    }

    public void setInput(File value) {
        this.input = () -> value;
    }

    public void setInput(Supplier<File> value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.output = this.getProject().file((Object)("build/" + this.getName() + "/output.sha256"));
        }
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setName(String value) {
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/" + value + ".sha256")));
        }
    }

    @TaskAction
    public void run() throws IOException {
        TreeMap checksums = Maps.newTreeMap();
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(this.getInput()));){
            ZipEntry entry;
            byte[] buff = new byte[1024];
            while ((entry = zin.getNextEntry()) != null) {
                HashingInputStream hash2 = new HashingInputStream(Hashing.sha256(), (InputStream)zin);
                while (hash2.read(buff, 0, buff.length) != -1) {
                }
                checksums.put(entry.getName(), Base64.getEncoder().encodeToString(hash2.hash().asBytes()));
            }
        }
        var3_3 = null;
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.getOutput())));){
            checksums.forEach((name, hash) -> {
                out.write((String)hash);
                out.write(32);
                out.write((String)name);
                out.write(10);
            });
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }
}

