/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.diff;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.diff.ContextualPatch;
import net.minecraftforge.gradle.common.diff.PatchContextProvider;
import net.minecraftforge.gradle.common.util.Utils;
import org.apache.commons.io.IOUtils;

public class ZipContext
implements PatchContextProvider {
    private final ZipFile zip;
    private final Map<String, List<String>> modified = new HashMap<String, List<String>>();
    private final Set<String> delete = new HashSet<String>();
    private final Map<String, byte[]> binary = new HashMap<String, byte[]>();

    public ZipContext(ZipFile zip) {
        this.zip = zip;
    }

    @Override
    public List<String> getData(ContextualPatch.SinglePatch patch) throws IOException {
        if (this.modified.containsKey(patch.targetPath)) {
            return this.modified.get(patch.targetPath);
        }
        ZipEntry entry = this.zip.getEntry(patch.targetPath);
        if (entry == null || patch.binary) {
            return null;
        }
        try (InputStream input = this.zip.getInputStream(entry);){
            List<String> list = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void setData(ContextualPatch.SinglePatch patch, List<String> data) throws IOException {
        if (patch.mode == ContextualPatch.Mode.DELETE || patch.binary && patch.hunks.length == 0) {
            this.delete.add(patch.targetPath);
            this.binary.remove(patch.targetPath);
            this.modified.remove(patch.targetPath);
        } else {
            this.delete.remove(patch.targetPath);
            if (patch.binary) {
                this.binary.put(patch.targetPath, Utils.base64DecodeStringList(patch.hunks[0].lines));
                this.modified.remove(patch.targetPath);
            } else {
                if (!patch.noEndingNewline) {
                    data.add("");
                }
                this.modified.put(patch.targetPath, data);
                this.binary.remove(patch.targetPath);
            }
        }
    }

    public void save(File file) throws IOException {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));){
            this.save(out);
        }
    }

    public void save(ZipOutputStream out) throws IOException {
        HashSet<String> files = new HashSet<String>();
        Enumeration<? extends ZipEntry> entries = this.zip.entries();
        while (entries.hasMoreElements()) {
            files.add(entries.nextElement().getName());
        }
        files.addAll(this.modified.keySet());
        files.addAll(this.delete);
        files.addAll(this.binary.keySet());
        ArrayList sorted = new ArrayList(files);
        Collections.sort(sorted);
        for (String key : sorted) {
            if (this.delete.contains(key)) continue;
            this.putNextEntry(out, key);
            if (this.binary.containsKey(key)) {
                out.write(this.binary.get(key));
            } else if (this.modified.containsKey(key)) {
                out.write(String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)this.modified.get(key)).getBytes(StandardCharsets.UTF_8));
            } else {
                try (InputStream ein = this.zip.getInputStream(this.zip.getEntry(key));){
                    IOUtils.copy((InputStream)ein, (OutputStream)out);
                }
            }
            out.closeEntry();
        }
    }

    private void putNextEntry(ZipOutputStream zip, String name) throws IOException {
        ZipEntry entry = new ZipEntry(name);
        entry.setTime(0L);
        zip.putNextEntry(entry);
    }
}

