/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.apache.commons.io.FileUtils;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;

public class RenameJarInPlace
extends JarExec {
    private File input;
    private File temp;
    private File mappings;

    public RenameJarInPlace() {
        this.tool = "net.md-5:SpecialSource:1.8.3:shaded";
        this.args = new String[]{"--in-jar", "{input}", "--out-jar", "{output}", "--srg-in", "{mappings}"};
        this.getOutputs().upToDateWhen(task -> false);
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{input}", this.getInput().getAbsolutePath());
        replace.put("{output}", this.temp.getAbsolutePath());
        replace.put("{mappings}", this.getMappings().getAbsolutePath());
        return Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
    }

    @Override
    @TaskAction
    public void apply() throws IOException {
        this.temp = this.getProject().file((Object)("build/" + this.getName() + "/output.jar"));
        if (!this.temp.getParentFile().exists()) {
            this.temp.getParentFile().mkdirs();
        }
        super.apply();
        FileUtils.copyFile((File)this.temp, (File)this.getInput());
    }

    @InputFile
    public File getMappings() {
        return this.mappings;
    }

    public void setMappings(File value) {
        this.mappings = value;
    }

    @InputFile
    public File getInput() {
        return this.input;
    }

    public void setInput(File value) {
        this.input = value;
    }
}

