/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev.tasks;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.gradle.common.task.JarExec;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;

public class ApplyBinPatches
extends JarExec {
    private Supplier<File> clean;
    private File input;
    private File output;

    public ApplyBinPatches() {
        this.tool = "net.minecraftforge:binarypatcher:1.+:fatjar";
        this.args = new String[]{"--clean", "{clean}", "--output", "{output}", "--apply", "{patch}"};
    }

    @Override
    protected List<String> filterArgs() {
        HashMap<String, String> replace = new HashMap<String, String>();
        replace.put("{clean}", this.getClean().getAbsolutePath());
        replace.put("{output}", this.getOutput().getAbsolutePath());
        replace.put("{patch}", this.getPatch().getAbsolutePath());
        return Arrays.stream(this.getArgs()).map(arg -> replace.getOrDefault(arg, (String)arg)).collect(Collectors.toList());
    }

    @InputFile
    public File getClean() {
        return this.clean.get();
    }

    public void setClean(File value) {
        this.clean = () -> value;
    }

    public void setClean(Supplier<File> value) {
        this.clean = value;
    }

    @InputFile
    public File getPatch() {
        return this.input;
    }

    public void setPatch(File value) {
        this.input = value;
    }

    @OutputFile
    public File getOutput() {
        if (this.output == null) {
            this.setOutput(this.getProject().file((Object)("build/" + this.getName() + "/output.jar")));
        }
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

