/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraftforge.gradle.common.task.DownloadMavenArtifact;
import net.minecraftforge.gradle.common.task.ExtractMCPData;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.MinecraftRepo;
import net.minecraftforge.gradle.mcp.MCPRepo;
import net.minecraftforge.gradle.userdev.MinecraftUserRepo;
import net.minecraftforge.gradle.userdev.UserDevExtension;
import net.minecraftforge.gradle.userdev.tasks.GenerateSRG;
import net.minecraftforge.gradle.userdev.tasks.RenameJarInPlace;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class UserDevPlugin
implements Plugin<Project> {
    private static String MINECRAFT = "minecraft";

    public void apply(final @Nonnull Project project) {
        Logger logger = project.getLogger();
        UserDevExtension extension = (UserDevExtension)project.getExtensions().create("minecraft", UserDevExtension.class, new Object[]{project});
        if (project.getPluginManager().findPlugin("java") == null) {
            project.getPluginManager().apply("java");
        }
        NamedDomainObjectContainer reobf = project.container(RenameJarInPlace.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<RenameJarInPlace>(){

            public RenameJarInPlace create(String jarName) {
                String name = Character.toUpperCase(jarName.charAt(0)) + jarName.substring(1);
                JavaPluginConvention java = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
                RenameJarInPlace task = (RenameJarInPlace)((Object)project.getTasks().maybeCreate("reobf" + name, RenameJarInPlace.class));
                task.setClasspath(((SourceSet)java.getSourceSets().getByName("main")).getCompileClasspath());
                project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
                project.afterEvaluate(p -> {
                    Task jar = project.getTasks().getByName(jarName);
                    if (!(jar instanceof Jar)) {
                        throw new IllegalStateException(jarName + "  is not a jar task. Can only reobf jars!");
                    }
                    task.setInput(((Jar)jar).getArchivePath());
                    task.dependsOn(new Object[]{jar});
                });
                return task;
            }
        });
        project.getExtensions().add("reobf", (Object)reobf);
        Configuration minecraft = (Configuration)project.getConfigurations().maybeCreate(MINECRAFT);
        Configuration compile = (Configuration)project.getConfigurations().maybeCreate("compile");
        compile.extendsFrom(new Configuration[]{minecraft});
        TaskProvider downloadMcpConfig = project.getTasks().register("downloadMcpConfig", DownloadMavenArtifact.class);
        TaskProvider extractSrg = project.getTasks().register("extractSrg", ExtractMCPData.class);
        extractSrg.configure(task -> {
            task.dependsOn(new Object[]{downloadMcpConfig});
            task.setConfig(((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).getOutput());
        });
        TaskProvider createMcpToSrg = project.getTasks().register("createMcpToSrg", GenerateSRG.class);
        createMcpToSrg.configure(task -> {
            task.setReverse(true);
            task.dependsOn(new Object[]{extractSrg});
            task.setSrg(((ExtractMCPData)((Object)((Object)extractSrg.get()))).getOutput());
            task.setMappings(extension.getMappings());
        });
        project.afterEvaluate(p -> {
            MinecraftUserRepo mcrepo = null;
            DependencySet deps = minecraft.getDependencies();
            for (Dependency dep : deps.stream().collect(Collectors.toList())) {
                if (!(dep instanceof ExternalModuleDependency)) {
                    throw new IllegalArgumentException("minecraft dependency must be a maven dependency.");
                }
                if (mcrepo != null) {
                    throw new IllegalArgumentException("Only allows one minecraft dependancy.");
                }
                deps.remove((Object)dep);
                mcrepo = new MinecraftUserRepo((Project)p, dep.getGroup(), dep.getName(), dep.getVersion(), extension.getAccessTransformers(), extension.getMappings());
                String newDep = mcrepo.getDependencyString();
                p.getLogger().lifecycle("New Dep: " + newDep);
                ExternalModuleDependency ext = (ExternalModuleDependency)p.getDependencies().create((Object)newDep);
                ext.setChanging(true);
                minecraft.resolutionStrategy(strat -> strat.cacheChangingModulesFor(0, TimeUnit.MINUTES));
                minecraft.getDependencies().add((Object)ext);
            }
            new BaseRepo.Builder().add(mcrepo).add(MCPRepo.create(project)).add(MinecraftRepo.create(project)).attach(project);
            project.getRepositories().maven(e -> e.setUrl((Object)"http://files.minecraftforge.net/maven/"));
            project.getRepositories().maven(e -> {
                e.setUrl((Object)"https://libraries.minecraft.net/");
                e.metadataSources(src -> src.artifact());
            });
            project.getRepositories().mavenCentral();
            if (mcrepo == null) {
                throw new IllegalStateException("Missing 'minecraft' dependency entry.");
            }
            mcrepo.validate();
            ((DownloadMavenArtifact)((Object)((Object)downloadMcpConfig.get()))).setArtifact("de.oceanlabs.mcp:mcp_config:" + project.getExtensions().getExtraProperties().get("MCP_VERSION") + "@zip");
            RenameJarInPlace reobfJar = (RenameJarInPlace)((Object)((Object)reobf.create("jar")));
            reobfJar.dependsOn(new Object[]{createMcpToSrg});
            reobfJar.setMappings(((GenerateSRG)((Object)((Object)createMcpToSrg.get()))).getOutput());
        });
    }
}

