/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.userdev;

import com.amadornes.artifactural.api.artifact.ArtifactIdentifier;
import com.amadornes.artifactural.api.repository.ArtifactProvider;
import com.amadornes.artifactural.api.repository.Repository;
import com.amadornes.artifactural.base.repository.ArtifactProviderBuilder;
import com.amadornes.artifactural.base.repository.SimpleRepository;
import com.cloudbees.diff.PatchException;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.UserdevConfigV1;
import net.minecraftforge.gradle.common.diff.ContextualPatch;
import net.minecraftforge.gradle.common.diff.HunkReport;
import net.minecraftforge.gradle.common.diff.PatchFile;
import net.minecraftforge.gradle.common.diff.ZipContext;
import net.minecraftforge.gradle.common.util.Artifact;
import net.minecraftforge.gradle.common.util.BaseRepo;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.HashStore;
import net.minecraftforge.gradle.common.util.MappingFile;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.common.util.McpNames;
import net.minecraftforge.gradle.common.util.POMBuilder;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.function.AccessTransformerFunction;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import net.minecraftforge.gradle.mcp.util.MCPWrapper;
import net.minecraftforge.gradle.userdev.tasks.ApplyBinPatches;
import net.minecraftforge.gradle.userdev.tasks.RenameJar;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtraPropertiesExtension;

public class MinecraftUserRepo
extends BaseRepo {
    private final Project project;
    private final String GROUP;
    private final String NAME;
    private final String VERSION;
    private final List<File> ATS;
    private final String AT_HASH;
    private final String MAPPING;
    private final boolean isPatcher;
    private final Map<String, McpNames> mapCache = new HashMap<String, McpNames>();
    private boolean loadedParents = false;
    private Patcher parent;
    private MCP mcp;
    private Repository repo;

    public MinecraftUserRepo(Project project, String group, String name, String version, List<File> ats, String mapping) {
        super(Utils.getCache(project, "minecraft_user_repo"), project.getLogger());
        this.project = project;
        this.GROUP = group;
        this.NAME = name;
        this.VERSION = version;
        this.ATS = ats.stream().filter(File::exists).collect(Collectors.toList());
        try {
            this.AT_HASH = this.ATS.isEmpty() ? null : HashFunction.SHA1.hash(this.ATS);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.MAPPING = mapping;
        this.isPatcher = !"net.minecraft".equals(this.GROUP);
        this.repo = SimpleRepository.of((ArtifactProvider)ArtifactProviderBuilder.begin(ArtifactIdentifier.class).filter(ArtifactIdentifier.groupEquals((String)this.GROUP)).filter(ArtifactIdentifier.nameEquals((String)this.NAME)).provide((ArtifactProvider)this));
    }

    public void validate() {
        this.getParents();
        if (this.mcp == null) {
            throw new IllegalStateException("Invalid minecraft dependency: " + this.GROUP + ":" + this.NAME + ":" + this.VERSION);
        }
        ExtraPropertiesExtension ext = this.project.getExtensions().getExtraProperties();
        ext.set("MC_VERSION", (Object)this.mcp.getMCVersion());
        ext.set("MCP_VERSION", (Object)this.mcp.getArtifact().getVersion());
    }

    private File cacheRaw(String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '.' + ext);
    }

    private File cacheRaw(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.VERSION, this.NAME + '-' + this.VERSION + '-' + classifier + '.' + ext);
    }

    private File cacheMapped(String mapping, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '.' + ext);
    }

    private File cacheMapped(String mapping, String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersion(mapping), this.NAME + '-' + this.getVersion(mapping) + '-' + classifier + '.' + ext);
    }

    private File cacheAT(String classifier, String ext) {
        return this.cache(this.GROUP.replace('.', File.separatorChar), this.NAME, this.getVersionAT(), this.NAME + '-' + this.getVersionAT() + '-' + classifier + '.' + ext);
    }

    public String getDependencyString() {
        String ret = this.GROUP + ':' + this.NAME + ':' + this.VERSION;
        if (this.MAPPING != null) {
            ret = ret + "_mapped_" + this.MAPPING;
        }
        if (this.AT_HASH != null) {
            ret = ret + "_at_" + this.AT_HASH;
        }
        ret = "rnd." + new Random().nextInt() + "." + ret;
        return ret;
    }

    private String getATHash(String version) {
        if (!version.contains("_at_")) {
            return null;
        }
        return version.split("_at_")[1];
    }

    private String getMappings(String version) {
        if (!version.contains("_mapped_")) {
            return null;
        }
        return version.split("_mapped_")[1];
    }

    private String getVersion(String mappings) {
        return mappings == null ? this.VERSION : this.VERSION + "_mapped_" + mappings;
    }

    private String getVersionWithAT(String mappings) {
        if (this.AT_HASH == null) {
            return this.getVersion(mappings);
        }
        return this.getVersion(mappings) + "_at_" + this.AT_HASH;
    }

    private String getVersionAT() {
        if (this.AT_HASH == null) {
            return this.VERSION;
        }
        return this.VERSION + "_at_" + this.AT_HASH;
    }

    private Patcher getParents() {
        if (!this.loadedParents) {
            String artifact = this.isPatcher ? this.GROUP + ':' + this.NAME + ':' + this.VERSION + ':' + "userdev" : "de.oceanlabs.mcp:mcp_config:" + this.VERSION + "@zip";
            boolean patcher = this.isPatcher;
            Patcher last = null;
            while (artifact != null) {
                this.debug("    Parent: " + artifact);
                File dep = MavenArtifactDownloader.single(this.project, artifact);
                if (dep == null) {
                    throw new IllegalStateException("Could not resolve dependency: " + artifact);
                }
                if (patcher) {
                    Patcher _new = new Patcher(this.project, dep, artifact);
                    if (this.parent == null) {
                        this.parent = _new;
                    }
                    if (last != null) {
                        last.setParent(_new);
                    }
                    last = _new;
                    patcher = !_new.parentIsMcp();
                    artifact = _new.getParentDesc();
                    continue;
                }
                this.mcp = new MCP(dep, artifact);
                break;
            }
            this.loadedParents = this.mcp != null;
        }
        return this.parent;
    }

    @Override
    public File findFile(ArtifactIdentifier artifact) throws IOException {
        String mappings;
        String version;
        String athash;
        String group = artifact.getGroup();
        String rand = "";
        if (group.startsWith("rnd.")) {
            rand = group.substring(0, group.indexOf(46, 4));
            group = group.substring(group.indexOf(46, 4) + 1);
        }
        if ((athash = this.getATHash(version = artifact.getVersion())) != null) {
            version = version.substring(0, version.length() - (athash.length() + "_at_".length()));
        }
        if ((mappings = this.getMappings(version)) != null) {
            version = version.substring(0, version.length() - (mappings.length() + "_mapped_".length()));
        }
        if (!(group.equals(this.GROUP) && artifact.getName().equals(this.NAME) && version.equals(this.VERSION))) {
            return null;
        }
        if (this.AT_HASH == null && athash != null || this.AT_HASH != null && !this.AT_HASH.equals(athash)) {
            return null;
        }
        if (!this.isPatcher && mappings == null) {
            return null;
        }
        String classifier = artifact.getClassifier() == null ? "" : artifact.getClassifier();
        String ext = artifact.getExtension().split("\\.")[0];
        this.debug("  " + this.REPO_NAME + " Request: " + artifact.getGroup() + ":" + artifact.getName() + ":" + version + ":" + classifier + "@" + ext + " Mapping: " + mappings);
        if ("pom".equals(ext)) {
            return this.findPom(mappings, rand);
        }
        switch (classifier) {
            case "": {
                return this.findRaw(mappings);
            }
            case "sources": {
                return this.findSource(mappings);
            }
        }
        return null;
    }

    private HashStore commonHash(File mapping) {
        this.getParents();
        HashStore ret = new HashStore(this.cache);
        ret.add(this.mcp.artifact.getDescriptor(), this.mcp.getZip());
        for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
            ret.add(this.parent.artifact.getDescriptor(), this.parent.data);
        }
        if (mapping != null) {
            ret.add("mapping", mapping);
        }
        if (this.AT_HASH != null) {
            ret.add("ats", this.AT_HASH);
        }
        return ret;
    }

    private File findMapping(String mapping) {
        if (mapping == null) {
            return null;
        }
        int idx = mapping.lastIndexOf(95);
        String channel = mapping.substring(0, idx);
        String version = mapping.substring(idx + 1);
        String desc = "de.oceanlabs.mcp:mcp_" + channel + ":" + version + "@zip";
        this.debug("    Mapping: " + desc);
        File central = MavenArtifactDownloader.single(this.project, desc);
        return central;
    }

    private File findPom(String mapping, String rand) throws IOException {
        this.getParents();
        if (this.mcp == null || mapping == null) {
            return null;
        }
        File pom = this.cacheMapped(mapping, "pom");
        if (!rand.isEmpty()) {
            rand = rand + '.';
            pom = this.cacheMapped(mapping, rand + "pom");
        }
        this.debug("  Finding pom: " + pom);
        HashStore cache = this.commonHash(null).load(new File(pom.getAbsolutePath() + ".input"));
        if (!cache.isSame() || !pom.exists()) {
            POMBuilder builder = new POMBuilder(rand + this.GROUP, this.NAME, this.getVersionWithAT(mapping));
            builder.dependencies().add(rand + this.GROUP + ':' + this.NAME + ':' + this.getVersionWithAT(mapping), "compile");
            builder.dependencies().add("net.minecraft:client:" + this.mcp.getMCVersion(), "compile").withClassifier("extra");
            builder.dependencies().add("net.minecraft:client:" + this.mcp.getMCVersion(), "compile").withClassifier("data");
            this.mcp.getLibraries().forEach(e -> builder.dependencies().add((String)e, "compile"));
            for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                patcher.getLibraries().forEach(e -> builder.dependencies().add((String)e, "compile"));
            }
            String ret = builder.tryBuild();
            if (ret == null) {
                return null;
            }
            FileUtils.writeByteArrayToFile((File)pom, (byte[])ret.getBytes());
            cache.save();
            Utils.updateHash(pom, HashFunction.SHA1);
        }
        return pom;
    }

    private File findBinPatches() throws IOException {
        File ret = this.cacheRaw("binpatches", "lzma");
        HashStore cache = new HashStore().load(this.cacheRaw("binpatches", "lzma.input")).add("parent", this.parent.getZip());
        if (!cache.isSame() || !ret.exists()) {
            try (ZipFile zip = new ZipFile(this.parent.getZip());){
                Utils.extractFile(zip, this.parent.getConfig().binpatches, ret);
                cache.save();
            }
        }
        return ret;
    }

    private File findRaw(String mapping) throws IOException {
        File names = this.findMapping(mapping);
        HashStore cache = this.commonHash(names);
        File recomp = this.cacheMapped(mapping, "recomp", "jar");
        if (recomp.exists()) {
            cache.load(this.cacheMapped(mapping, "recomp", "jar.input"));
            this.debug("  Finding recomp: " + cache.isSame() + " " + recomp);
            if (cache.isSame()) {
                return recomp;
            }
        }
        File bin = this.cacheMapped(mapping, "jar");
        cache.load(this.cacheMapped(mapping, "jar.input"));
        if (!cache.isSame() || !bin.exists()) {
            File srged = null;
            if (this.parent == null) {
                srged = MavenArtifactDownloader.single(this.project, "net.minecraft:joined:" + this.mcp.getVersion() + ":srg");
            } else {
                File joined = MavenArtifactDownloader.single(this.project, "net.minecraft:joined:" + this.mcp.getVersion() + ":srg");
                File binpatched = this.cacheRaw("binpatched", "jar");
                ApplyBinPatches apply = (ApplyBinPatches)this.project.getTasks().create("_" + new Random().nextInt() + "_", ApplyBinPatches.class);
                apply.setHasLog(false);
                apply.setTool(this.parent.getConfig().binpatcher.getVersion());
                apply.setArgs(this.parent.getConfig().binpatcher.getArgs());
                apply.setClean(joined);
                apply.setPatch(this.findBinPatches());
                apply.setOutput(binpatched);
                apply.apply();
                srged = this.cacheRaw("srg", "jar");
                HashSet<String> added = new HashSet<String>();
                try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(srged));){
                    for (File file : new File[]{binpatched, joined}) {
                        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(file));){
                            ZipEntry entry;
                            while ((entry = zin.getNextEntry()) != null) {
                                if (added.contains(entry.getName())) continue;
                                ZipEntry _new = new ZipEntry(entry.getName());
                                _new.setTime(entry.getTime());
                                zip.putNextEntry(_new);
                                IOUtils.copy((InputStream)zin, (OutputStream)zip);
                                added.add(entry.getName());
                            }
                        }
                    }
                    for (Patcher patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                        if (patcher.getUniversal() == null) continue;
                        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(patcher.getUniversal()));){
                            ZipEntry entry;
                            while ((entry = zin.getNextEntry()) != null) {
                                if (added.contains(entry.getName())) continue;
                                ZipEntry _new = new ZipEntry(entry.getName());
                                _new.setTime(0L);
                                zip.putNextEntry(_new);
                                IOUtils.copy((InputStream)zin, (OutputStream)zip);
                                added.add(entry.getName());
                            }
                            continue;
                        }
                    }
                }
            }
            if (mapping == null) {
                FileUtils.copyFile((File)srged, (File)bin);
            } else {
                RenameJar rename = (RenameJar)this.project.getTasks().create("_" + new Random().nextInt() + "_", RenameJar.class);
                rename.setHasLog(false);
                rename.setInput(srged);
                rename.setOutput(bin);
                rename.setMappings(this.findSrgToMcp(mapping, names));
                rename.apply();
            }
            Utils.updateHash(bin, HashFunction.SHA1);
            cache.save();
        }
        return bin;
    }

    private McpNames loadMCPNames(String name, File data) throws IOException {
        McpNames map = this.mapCache.get(name);
        String hash = HashFunction.SHA1.hash(data);
        if (map == null || !hash.equals(map.hash)) {
            map = McpNames.load(data);
            this.mapCache.put(name, map);
        }
        return map;
    }

    private File findSrgToMcp(String mapping, File names) throws IOException {
        File root = this.cache(this.mcp.getArtifact().getGroup().replace('.', '/'), this.mcp.getArtifact().getName(), this.mcp.getArtifact().getVersion());
        String srg_name = "srg_to_" + mapping + ".tsrg";
        File srg = new File(root, srg_name);
        HashStore cache = new HashStore().add("mcp", this.mcp.getZip()).add("mapping", names).load(new File(root, srg_name + ".input"));
        if (!cache.isSame() || !srg.exists()) {
            this.info("Creating SRG -> MCP TSRG");
            byte[] data = this.mcp.getData("mappings");
            McpNames mcp_names = this.loadMCPNames(mapping, names);
            MappingFile obf_to_srg = MappingFile.load(new ByteArrayInputStream(data));
            MappingFile srg_to_named = new MappingFile();
            obf_to_srg.getPackages().forEach(e -> srg_to_named.addPackage(e.getMapped(), e.getMapped()));
            obf_to_srg.getClasses().forEach(cls -> {
                srg_to_named.addClass(cls.getMapped(), cls.getMapped());
                MappingFile.Cls _cls = srg_to_named.getClass(cls.getMapped());
                cls.getFields().forEach(fld -> _cls.addField(fld.getMapped(), mcp_names.rename(fld.getMapped())));
                cls.getMethods().forEach(mtd -> _cls.addMethod(mtd.getMapped(), mtd.getMappedDescriptor(), mcp_names.rename(mtd.getMapped())));
            });
            srg_to_named.write(MappingFile.Format.TSRG, srg, false);
            cache.save();
        }
        return srg;
    }

    private File findDecomp() throws IOException {
        HashStore cache = this.commonHash(null);
        File decomp = this.cacheAT("decomp", "jar");
        this.debug("    Finding Decomp: " + decomp);
        cache.load(this.cacheAT("decomp", "jar.input"));
        if (!cache.isSame() || !decomp.exists()) {
            File output = this.mcp.getStepOutput("joined", null);
            FileUtils.copyFile((File)output, (File)decomp);
            cache.save();
            Utils.updateHash(decomp, HashFunction.SHA1);
        }
        return decomp;
    }

    private File findPatched() throws IOException {
        File decomp = this.findDecomp();
        if (decomp == null) {
            return null;
        }
        if (this.parent == null) {
            return decomp;
        }
        HashStore cache = this.commonHash(null).add("decomp", decomp);
        File patched = this.cacheAT("patched", "jar");
        this.debug("    Finding patched: " + decomp);
        cache.load(this.cacheAT("patched", "jar.input"));
        if (!cache.isSame() || !patched.exists()) {
            Patcher patcher;
            LinkedList<Patcher> parents = new LinkedList<Patcher>();
            for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                parents.addFirst(patcher);
            }
            try (ZipFile zip = new ZipFile(decomp);){
                ZipContext context = new ZipContext(zip);
                boolean failed = false;
                for (Patcher p : parents) {
                    Map<String, PatchFile> patches = p.getPatches();
                    if (patches.isEmpty()) continue;
                    this.debug("      Apply Patches: " + p.artifact);
                    ArrayList<String> keys = new ArrayList<String>(patches.keySet());
                    Collections.sort(keys);
                    for (String key : keys) {
                        ContextualPatch patch = ContextualPatch.create(patches.get(key), context);
                        patch.setCanonialization(true, false);
                        patch.setMaxFuzz(0);
                        try {
                            this.debug("        Apply Patch: " + key);
                            List<ContextualPatch.PatchReport> result = patch.patch(false);
                            for (int x = 0; x < result.size(); ++x) {
                                ContextualPatch.PatchReport report = result.get(x);
                                if (report.getStatus().isSuccess()) continue;
                                this.log.error("  Failed to apply patch: " + p.artifact + ": " + key);
                                failed = true;
                                for (int y = 0; y < report.hunkReports().size(); ++y) {
                                    HunkReport hunk = report.hunkReports().get(y);
                                    if (!hunk.hasFailed()) continue;
                                    if (hunk.failure == null) {
                                        this.log.error("    Hunk #" + hunk.hunkID + " Failed @" + hunk.index + " Fuzz: " + hunk.fuzz);
                                        continue;
                                    }
                                    this.log.error("    Hunk #" + hunk.hunkID + " Failed: " + hunk.failure.getMessage());
                                }
                            }
                        }
                        catch (PatchException e) {
                            this.log.error("  Apply Patch: " + p.artifact + ": " + key);
                            this.log.error("    " + e.getMessage());
                        }
                    }
                }
                if (failed) {
                    throw new RuntimeException("Failed to apply patches to source file, see log for details: " + decomp);
                }
                HashSet<String> added = new HashSet<String>();
                try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(patched));){
                    context.save(zout);
                    for (patcher = this.parent; patcher != null; patcher = patcher.getParent()) {
                        if (patcher.getSources() == null) continue;
                        ZipInputStream zin = new ZipInputStream(new FileInputStream(patcher.getSources()));
                        Object object = null;
                        try {
                            ZipEntry entry;
                            while ((entry = zin.getNextEntry()) != null) {
                                if (added.contains(entry.getName()) || entry.getName().startsWith("patches/")) continue;
                                ZipEntry _new = new ZipEntry(entry.getName());
                                _new.setTime(0L);
                                zout.putNextEntry(_new);
                                IOUtils.copy((InputStream)zin, (OutputStream)zout);
                                added.add(entry.getName());
                            }
                            continue;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (zin != null) {
                                if (object != null) {
                                    try {
                                        zin.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    zin.close();
                                }
                            }
                        }
                    }
                }
                cache.save();
                Utils.updateHash(patched, HashFunction.SHA1);
            }
        }
        return patched;
    }

    private File findSource(String mapping) throws IOException {
        File patched = this.findPatched();
        if (patched == null) {
            return null;
        }
        if (mapping == null) {
            return patched;
        }
        File names = this.findMapping(mapping);
        if (names == null) {
            return null;
        }
        HashStore cache = this.commonHash(names);
        File sources = this.cacheMapped(mapping, "sources", "jar");
        this.debug("    Finding Source: " + sources);
        cache.load(this.cacheMapped(mapping, "sources", "jar.input"));
        if (!cache.isSame() || !sources.exists()) {
            McpNames map = McpNames.load(names);
            if (!sources.getParentFile().exists()) {
                sources.getParentFile().mkdirs();
            }
            try (ZipInputStream zin = new ZipInputStream(new FileInputStream(patched));
                 ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(sources));){
                ZipEntry _old;
                while ((_old = zin.getNextEntry()) != null) {
                    ZipEntry _new = new ZipEntry(_old.getName());
                    _new.setTime(0L);
                    zout.putNextEntry(_new);
                    if (_old.getName().endsWith(".java")) {
                        String mapped = map.rename(zin, true);
                        IOUtils.write((String)mapped, (OutputStream)zout);
                        continue;
                    }
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                }
            }
            Utils.updateHash(sources, HashFunction.SHA1);
            cache.save();
        }
        return sources;
    }

    private class MCP {
        private final MCPWrapper wrapper;
        private final Artifact artifact;

        private MCP(final File data, String artifact) {
            this.artifact = Artifact.from(artifact);
            try {
                File mcp_dir = MinecraftUserRepo.this.cache(new String[]{"mcp", this.artifact.getVersion()});
                this.wrapper = new MCPWrapper(data, mcp_dir){

                    @Override
                    public MCPRuntime getRuntime(Project project, String side) {
                        MCPRuntime ret = (MCPRuntime)this.runtimes.get(side);
                        if (ret == null) {
                            File dir = new File(MCP.this.wrapper.getRoot(), side);
                            String AT_HASH = MinecraftUserRepo.this.AT_HASH;
                            List ATS = MinecraftUserRepo.this.ATS;
                            AccessTransformerFunction function = new AccessTransformerFunction(project, ATS);
                            boolean empty = true;
                            if (AT_HASH != null) {
                                dir = new File(dir, AT_HASH);
                                empty = false;
                            }
                            for (Patcher patcher = MinecraftUserRepo.this.parent; patcher != null; patcher = patcher.getParent()) {
                                String at = patcher.getATData();
                                if (at == null || at.isEmpty()) continue;
                                function.addTransformer(at);
                                empty = false;
                            }
                            HashMap preDecomps = Maps.newHashMap();
                            if (!empty) {
                                preDecomps.put("AccessTransformer", function);
                            }
                            ret = new MCPRuntime(project, data, this.getConfig(), side, dir, preDecomps);
                            this.runtimes.put(side, ret);
                        }
                        return ret;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public byte[] getData(String ... path) throws IOException {
            return this.wrapper.getData(path);
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public File getZip() {
            return this.wrapper.getZip();
        }

        public String getVersion() {
            return this.artifact.getVersion();
        }

        public String getMCVersion() {
            return this.wrapper.getConfig().getVersion();
        }

        public List<String> getLibraries() {
            return this.wrapper.getConfig().getLibraries("joined");
        }

        public File getStepOutput(String side, String step) throws IOException {
            MCPRuntime runtime = this.wrapper.getRuntime(MinecraftUserRepo.this.project, side);
            try {
                return runtime.execute(MinecraftUserRepo.this.log, step);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                MinecraftUserRepo.this.log.lifecycle(e.getMessage());
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static class Patcher {
        private final File data;
        private final File universal;
        private final File sources;
        private final Artifact artifact;
        private final UserdevConfigV1 config;
        private Patcher parent;
        private String ATs = null;
        private Map<String, PatchFile> patches;

        private Patcher(Project project, File data, String artifact) {
            this.data = data;
            this.artifact = Artifact.from(artifact);
            try {
                byte[] cfg_data = Utils.getZipData(data, "config.json");
                int spec = Config.getSpec(cfg_data);
                if (spec != 1) {
                    throw new IllegalStateException("Could not load Patcher config, Unknown Spec: " + spec + " Dep: " + artifact);
                }
                this.config = UserdevConfigV1.get(cfg_data);
                if (this.getParentDesc() == null) {
                    throw new IllegalStateException("Invalid patcher dependency, missing MCP or parent: " + artifact);
                }
                if (this.config.universal != null) {
                    this.universal = MavenArtifactDownloader.single(project, this.config.universal);
                    if (this.universal == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve universal: " + this.universal);
                    }
                } else {
                    this.universal = null;
                }
                if (this.config.sources != null) {
                    this.sources = MavenArtifactDownloader.single(project, this.config.sources);
                    if (this.sources == null) {
                        throw new IllegalStateException("Invalid patcher dependency, could not resolve sources: " + this.sources);
                    }
                } else {
                    this.sources = null;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid patcher dependency: " + artifact, e);
            }
        }

        public UserdevConfigV1 getConfig() {
            return this.config;
        }

        public boolean parentIsMcp() {
            return this.config.mcp != null;
        }

        public void setParent(Patcher value) {
            this.parent = value;
        }

        public Patcher getParent() {
            return this.parent;
        }

        public String getParentDesc() {
            return this.config.mcp != null ? this.config.mcp : this.config.parent;
        }

        public List<String> getLibraries() {
            return this.config.libraries == null ? Collections.emptyList() : this.config.libraries;
        }

        public String getATData() {
            if (this.config.getATs().isEmpty()) {
                return null;
            }
            if (this.ATs == null) {
                StringBuilder buf = new StringBuilder();
                try (ZipFile zip = new ZipFile(this.data);){
                    for (String at : this.config.getATs()) {
                        ZipEntry entry = zip.getEntry(at);
                        if (entry == null) {
                            throw new IllegalStateException("Invalid Patcher config, Missing Access Transformer: " + at + " Zip: " + this.data);
                        }
                        buf.append("# ").append(this.artifact).append(" - ").append(at).append('\n');
                        buf.append(IOUtils.toString((InputStream)zip.getInputStream(entry), (Charset)Charsets.UTF_8));
                        buf.append('\n');
                    }
                    this.ATs = buf.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("Invalid patcher config: " + this.artifact, e);
                }
            }
            return this.ATs;
        }

        public File getZip() {
            return this.data;
        }

        public File getUniversal() {
            return this.universal;
        }

        public File getSources() {
            return this.sources;
        }

        public Map<String, PatchFile> getPatches() throws IOException {
            if (this.config.patches == null) {
                return Collections.emptyMap();
            }
            if (this.patches == null) {
                this.patches = new HashMap<String, PatchFile>();
                try (ZipInputStream zin = new ZipInputStream(new FileInputStream(this.getZip()));){
                    ZipEntry entry;
                    while ((entry = zin.getNextEntry()) != null) {
                        if (!entry.getName().startsWith(this.config.patches) || !entry.getName().endsWith(".patch")) continue;
                        byte[] data = IOUtils.toByteArray((InputStream)zin);
                        this.patches.put(entry.getName().substring(0, entry.getName().length() - 6), PatchFile.from(data));
                    }
                }
            }
            return this.patches;
        }
    }
}

