/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.common.util.VersionJson;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class TaskExtractNatives
extends DefaultTask {
    private File meta;
    private File output;

    @TaskAction
    public void run() throws IOException {
        VersionJson json = Utils.loadJson(this.getMeta(), VersionJson.class);
        for (VersionJson.LibraryDownload lib : json.getNatives()) {
            File target = Utils.getCache(this.getProject(), "libraries", lib.path);
            Utils.updateDownload(this.getProject(), target, lib);
            Utils.extractZip(target, this.getOutput(), false);
        }
    }

    @InputFile
    public File getMeta() {
        return this.meta;
    }

    public void setMeta(File value) {
        this.meta = value;
    }

    @OutputDirectory
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

