/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.gradle.common.util.ChainedInputSupplier;
import net.minecraftforge.srg2source.rangeapplier.RangeApplier;
import net.minecraftforge.srg2source.util.io.FolderSupplier;
import net.minecraftforge.srg2source.util.io.InputSupplier;
import net.minecraftforge.srg2source.util.io.OutputSupplier;
import net.minecraftforge.srg2source.util.io.ZipInputSupplier;
import net.minecraftforge.srg2source.util.io.ZipOutputSupplier;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class TaskApplyRangeMap
extends DefaultTask {
    private Set<File> srgs = new HashSet<File>();
    private Set<File> excs = new HashSet<File>();
    private Set<File> sources = new HashSet<File>();
    private File rangeMap;
    public boolean annotate = false;
    public boolean keepImports = true;
    private File output = this.getProject().file((Object)("build/" + this.getName() + "/output.zip"));
    private File log = this.getProject().file((Object)("build/" + this.getName() + "/log.txt"));

    @TaskAction
    public void applyRangeMap() throws IOException {
        RangeApplier apply = new RangeApplier();
        apply.readSrg(this.getSrgFiles());
        apply.readParamMap(this.getExcFiles());
        apply.setKeepImports(this.getKeepImports());
        try (FileOutputStream fos = new FileOutputStream(this.log);
             ZipOutputSupplier out = new ZipOutputSupplier(this.getOutput());){
            apply.setOutLogger(new PrintStream(fos));
            apply.remapSources(this.getInputSupplier(), (OutputSupplier)out, this.getRangeMap(), this.getAnnotate());
        }
    }

    private InputSupplier getInputSupplier() throws IOException {
        ChainedInputSupplier inputs = new ChainedInputSupplier(new InputSupplier[0]);
        for (File src : this.getSources()) {
            if (!src.exists()) continue;
            inputs.add((InputSupplier)(src.isDirectory() ? new FolderSupplier(src) : new ZipInputSupplier(src)));
        }
        return inputs.shrink();
    }

    @InputFiles
    public Set<File> getSrgFiles() {
        return this.srgs;
    }

    public void setSrgFiles(File ... values) {
        for (File value : values) {
            this.srgs.add(value);
        }
    }

    @InputFiles
    public Set<File> getSources() {
        return this.sources;
    }

    public void setSources(Collection<File> values) {
        this.sources.addAll(values);
    }

    public void setSources(File ... values) {
        for (File value : values) {
            this.sources.add(value);
        }
    }

    @InputFile
    public File getRangeMap() {
        return this.rangeMap;
    }

    public void setRangeMap(File value) {
        this.rangeMap = value;
    }

    @Input
    public boolean getAnnotate() {
        return this.annotate;
    }

    public void setAnnotate(boolean value) {
        this.annotate = value;
    }

    @Input
    public boolean getKeepImports() {
        return this.keepImports;
    }

    public void setKeepImports(boolean value) {
        this.keepImports = value;
    }

    @InputFiles
    public Set<File> getExcFiles() {
        return this.excs;
    }

    public void setExcFiles(File ... values) {
        for (File value : values) {
            this.excs.add(value);
        }
    }

    public void setExcFiles(Collection<File> values) {
        this.excs.addAll(values);
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File value) {
        this.output = value;
    }
}

