/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.patcher.task;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class DownloadMCPMappingsTask
extends DefaultTask {
    private String mappings;
    private File output = this.getProject().file((Object)"build/mappings.zip");

    @Input
    public String getMappings() {
        return this.mappings;
    }

    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setMappings(String value) {
        this.mappings = value;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @TaskAction
    public void download() throws IOException {
        File out = this.getMappingFile();
        if (out != null && out.exists()) {
            this.setDidWork(true);
        } else {
            this.setDidWork(false);
        }
        if (FileUtils.contentEquals((File)out, (File)this.output)) {
            return;
        }
        if (this.output.exists()) {
            this.output.delete();
        }
        if (!this.output.getParentFile().exists()) {
            this.output.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)out, (File)this.output);
    }

    private File getMappingFile() {
        return MavenArtifactDownloader.single(this.getProject(), this.getMappings());
    }
}

