/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.Config;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.Utils;
import net.minecraftforge.gradle.mcp.util.MCPRuntime;
import org.gradle.api.Project;

public class MCPWrapper {
    private final String hash;
    private final File data;
    private final File root;
    private final MCPConfigV1 config;
    protected final Map<String, MCPRuntime> runtimes = Maps.newHashMap();

    public MCPWrapper(File data, File root) throws IOException {
        this(HashFunction.SHA1.hash(data), data, root);
    }

    public MCPWrapper(String hash, File data, File root) throws IOException {
        this.hash = hash;
        this.data = data;
        this.root = root;
        byte[] cfg_data = Utils.getZipData(data, "config.json");
        int spec = Config.getSpec(cfg_data);
        if (spec != 1) {
            throw new IllegalStateException("Could not load MCP config, Unknown Spec: " + spec + " File: " + data);
        }
        this.config = MCPConfigV1.get(cfg_data);
    }

    public MCPRuntime getRuntime(Project project, String side) {
        MCPRuntime ret = this.runtimes.get(side);
        if (ret == null) {
            ret = new MCPRuntime(project, this.data, this.config, side, new File(this.root, side), Collections.emptyMap());
            this.runtimes.put(side, ret);
        }
        return ret;
    }

    public File getZip() {
        return this.data;
    }

    public String getHash() {
        return this.hash;
    }

    public MCPConfigV1 getConfig() {
        return this.config;
    }

    public File getRoot() {
        return this.root;
    }

    public void extractData(File target, String ... path) throws IOException {
        String name = this.config.getData(path);
        if (name == null) {
            throw new IOException("Unknown MCP Entry: " + Joiner.on((String)"/").join((Object[])path));
        }
        try (ZipFile zip = new ZipFile(this.data);){
            Utils.extractFile(zip, name, target);
        }
    }

    public byte[] getData(String ... path) throws IOException {
        String name = this.config.getData(path);
        if (name == null) {
            throw new IOException("Unknown MCP Entry: " + Joiner.on((String)"/").join((Object[])path));
        }
        return Utils.getZipData(this.data, name);
    }
}

