/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.mcp.util;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.util.MavenArtifactDownloader;
import net.minecraftforge.gradle.mcp.MCPPlugin;
import net.minecraftforge.gradle.mcp.function.ExecuteFunction;
import net.minecraftforge.gradle.mcp.function.MCPFunction;
import net.minecraftforge.gradle.mcp.util.MCPEnvironment;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;

public class MCPRuntime {
    private static final Pattern OUTPUT_REPLACE_PATTERN = Pattern.compile("^\\{(\\w+)Output\\}$");
    final Project project;
    final MCPEnvironment environment;
    final File mcpDirectory;
    private final File zipFile;
    final Map<String, Step> steps = new LinkedHashMap<String, Step>();
    Step currentStep;

    public MCPRuntime(Project project, File mcp_config, MCPConfigV1 config, String side, File mcpDirectory, Map<String, MCPFunction> extraPres) {
        this.project = project;
        this.environment = new MCPEnvironment(this, config.getVersion());
        this.mcpDirectory = mcpDirectory;
        this.zipFile = mcp_config;
        Map<String, String> data = config.getData().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof Map ? (String)((Map)e.getValue()).get(side) : (String)e.getValue()));
        List<MCPConfigV1.Step> steps = config.getSteps(side);
        if (steps.isEmpty()) {
            throw new IllegalArgumentException("Unknown side: " + side + " For Config: " + mcp_config);
        }
        boolean hasDownloadJson = false;
        for (MCPConfigV1.Step step : steps) {
            if (step.getName().equals("decompile") && !extraPres.isEmpty()) {
                String input = step.getValues().get("input");
                String lastName = null;
                for (Map.Entry<String, MCPFunction> entry : extraPres.entrySet()) {
                    String name = entry.getKey();
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("input", input);
                    this.steps.put(name, new Step(name, entry.getValue(), args, new File(this.mcpDirectory, name), data));
                    input = "{" + name + "Output}";
                    lastName = name;
                }
                step.getValues().put("input", "{" + lastName + "Output}");
            }
            MCPFunction function = MCPPlugin.createBuiltInFunction(step.getType());
            if ("downloadJson".equals(step.getType())) {
                hasDownloadJson = true;
            }
            if ("downloadServer".equals(step.getType()) && !hasDownloadJson) {
                this.steps.put("downloadJson", new Step("downloadJson", MCPPlugin.createBuiltInFunction("downloadJson"), Collections.emptyMap(), new File(this.mcpDirectory, "downloadJson"), data));
                hasDownloadJson = true;
            }
            if (function == null) {
                MCPConfigV1.Function custom = config.getFunction(step.getType());
                if (custom == null) {
                    throw new IllegalArgumentException("Invalid MCP Config, Unknown function step type: " + step.getType() + " File: " + mcp_config);
                }
                File jar = MavenArtifactDownloader.single(project, custom.getVersion());
                if (jar == null || !jar.exists()) {
                    throw new IllegalArgumentException("Could not download MCP Config dependency: " + custom.getVersion());
                }
                function = new ExecuteFunction(jar, custom.getJvmArgs().toArray(new String[custom.getJvmArgs().size()]), custom.getArgs().toArray(new String[custom.getArgs().size()]), Collections.emptyMap());
            }
            File workingDir = new File(this.mcpDirectory, step.getName());
            this.steps.put(step.getName(), new Step(step.getName(), function, step.getValues(), workingDir, data));
        }
    }

    public File execute(Logger logger) throws Exception {
        return this.execute(logger, null);
    }

    public File executeUpTo(Logger logger, String stop) throws Exception {
        String last = null;
        for (Step step : this.steps.values()) {
            if (step.name.equals(stop)) break;
            last = step.name;
        }
        return this.execute(logger, last);
    }

    public File execute(Logger logger, String stop) throws Exception {
        this.environment.logger = logger;
        logger.lifecycle("Setting up MCP environment");
        logger.lifecycle("Initializing steps");
        ZipFile zip = new ZipFile(this.zipFile);
        for (Step step : this.steps.values()) {
            logger.info(" > Initializing '" + step.name + "'");
            this.currentStep = step;
            step.initialize(zip);
        }
        zip.close();
        File ret = null;
        logger.lifecycle("Executing steps");
        for (Step step : this.steps.values()) {
            logger.lifecycle(" > Running '" + step.name + "'");
            this.currentStep = step;
            step.arguments.replaceAll((key, value) -> value instanceof String ? this.applyStepOutputSubstitutions((String)value) : value);
            ret = step.execute();
            if (stop == null || !stop.equals(step.name)) continue;
            logger.lifecycle("Stopping at requested step: " + ret);
            return ret;
        }
        logger.lifecycle("MCP environment setup is complete");
        return ret;
    }

    private Object applyStepOutputSubstitutions(String value) {
        Matcher matcher = OUTPUT_REPLACE_PATTERN.matcher(value);
        if (!matcher.find()) {
            return value;
        }
        String stepName = matcher.group(1);
        if (stepName != null) {
            return this.environment.getStepOutput(stepName);
        }
        throw new IllegalStateException("The string '" + value + "' did not return a valid substitution match!");
    }

    class Step {
        private final String name;
        private final MCPFunction function;
        final Map<String, Object> arguments;
        final File workingDirectory;
        File output;

        private Step(String name, MCPFunction function, Map<String, String> arguments, File workingDirectory, Map<String, String> data) {
            this.name = name;
            this.function = function;
            this.arguments = new HashMap<String, String>(arguments);
            this.workingDirectory = workingDirectory;
            function.loadData(data);
        }

        private void initialize(ZipFile zip) throws Exception {
            this.function.initialize(MCPRuntime.this.environment, zip);
        }

        private File execute() throws Exception {
            try {
                this.output = this.function.execute(MCPRuntime.this.environment);
            }
            finally {
                this.function.cleanup(MCPRuntime.this.environment);
            }
            return this.output;
        }

        boolean isOfType(Class<? extends MCPFunction> type) {
            return type.isAssignableFrom(this.function.getClass());
        }
    }
}

