/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.gradle.common.util.Artifact;

public class VersionJson {
    public AssetIndex assetIndex;
    public String assets;
    public Map<String, Download> downloads;
    public Library[] libraries;
    private List<LibraryDownload> _natives = null;

    public List<LibraryDownload> getNatives() {
        if (this._natives == null) {
            this._natives = new ArrayList<LibraryDownload>();
            OS os = OS.getCurrent();
            for (Library lib : this.libraries) {
                LibraryDownload l;
                if (lib.natives == null || lib.downloads.classifiers == null || !lib.natives.containsKey(os.getName()) || (l = lib.downloads.classifiers.get(lib.natives.get(os.getName()))) == null) continue;
                this._natives.add(l);
            }
        }
        return this._natives;
    }

    public static enum OS {
        WINDOWS("windows", "win"),
        LINUX("linux", "linux", "unix"),
        OSX("osx", "mac"),
        UNKNOWN("unknown", new String[0]);

        private final String name;
        private final String[] keys;

        private OS(String name, String ... keys) {
            this.name = name;
            this.keys = keys;
        }

        public String getName() {
            return this.name;
        }

        public static OS getCurrent() {
            String prop = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            for (OS os : OS.values()) {
                for (String key : os.keys) {
                    if (!prop.contains(key)) continue;
                    return os;
                }
            }
            return UNKNOWN;
        }
    }

    public static class Library {
        public String name;
        public Map<String, String> natives;
        public Downloads downloads;
        private Artifact _artifact;

        public Artifact getArtifact() {
            if (this._artifact == null) {
                this._artifact = Artifact.from(this.name);
            }
            return this._artifact;
        }
    }

    public static class Downloads {
        public Map<String, LibraryDownload> classifiers;
        public LibraryDownload artifact;
    }

    public static class LibraryDownload
    extends Download {
        public String path;
    }

    public static class Download {
        public String sha1;
        public int size;
        public URL url;
    }

    public static class AssetIndex
    extends Download {
        public String id;
        public int totalSize;
    }
}

