/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import groovy.lang.Closure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.config.MCPConfigV1;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.VersionJson;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.gradle.api.Project;

public class Utils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(MCPConfigV1.Step.class, (Object)new MCPConfigV1.Step.Deserializer()).setPrettyPrinting().create();

    public static void extractFile(ZipFile zip, String name, File output) throws IOException {
        Utils.extractFile(zip, zip.getEntry(name), output);
    }

    public static void extractFile(ZipFile zip, ZipEntry entry, File output) throws IOException {
        File parent = output.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (InputStream stream = zip.getInputStream(entry);){
            Files.copy(stream, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void extractDirectory(Function<String, File> fileLocator, ZipFile zip, String directory) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry e = entries.nextElement();
            if (e.isDirectory() || !e.getName().startsWith(directory)) continue;
            Utils.extractFile(zip, e, fileLocator.apply(e.getName()));
        }
    }

    public static byte[] base64DecodeStringList(List<String> strings) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String string : strings) {
            bos.write(Base64.getDecoder().decode(string));
        }
        return bos.toByteArray();
    }

    public static File delete(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    public static File createEmpty(File file) throws IOException {
        file = Utils.delete(file);
        file.createNewFile();
        return file;
    }

    public static File getCacheBase(Project project) {
        return new File(project.getGradle().getGradleUserHomeDir(), "caches/forge_gradle");
    }

    public static File getCache(Project project, String ... tail) {
        return new File(Utils.getCacheBase(project), String.join((CharSequence)File.separator, tail));
    }

    public static void extractZip(File source, File target, boolean overwrite) throws IOException {
        try (ZipFile zip = new ZipFile(source);){
            Enumeration<? extends ZipEntry> enu = zip.entries();
            while (enu.hasMoreElements()) {
                File out;
                ZipEntry e = enu.nextElement();
                if (e.isDirectory() || (out = new File(target, e.getName())).exists() && !overwrite) continue;
                File parent = out.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(out);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)zip.getInputStream(e), (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fos == null) continue;
                    if (throwable != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fos.close();
                }
            }
        }
    }

    public static File updateDownload(Project project, File target, VersionJson.Download dl) throws IOException {
        if (!target.exists() || !HashFunction.SHA1.hash(target).equals(dl.sha1)) {
            project.getLogger().lifecycle("Downloading: " + dl.url);
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            FileUtils.copyURLToFile((URL)dl.url, (File)target);
        }
        return target;
    }

    public static <T> T loadJson(File target, Class<T> clz) throws IOException {
        try (FileInputStream in = new FileInputStream(target);){
            Object object = GSON.fromJson((Reader)new InputStreamReader(in), clz);
            return (T)object;
        }
    }

    public static <T> T loadJson(InputStream in, Class<T> clz) throws IOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(in), clz);
    }

    public static void updateHash(File target) throws IOException {
        Utils.updateHash(target, HashFunction.values());
    }

    public static void updateHash(File target, HashFunction ... functions) throws IOException {
        for (HashFunction function : functions) {
            File cache = new File(target.getAbsolutePath() + "." + function.getExtension());
            if (target.exists()) {
                String hash = function.hash(target);
                Files.write(cache.toPath(), hash.getBytes(), new OpenOption[0]);
                continue;
            }
            if (!cache.exists()) continue;
            cache.delete();
        }
    }

    public static void forZip(ZipFile zip, IOConsumer<ZipEntry> consumer) throws IOException {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            consumer.accept(entries.nextElement());
        }
    }

    public static String resolveString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Closure) {
            return Utils.resolveString(((Closure)obj).call());
        }
        if (obj instanceof Callable) {
            try {
                return Utils.resolveString(((Callable)obj).call());
            }
            catch (Exception e) {
                return null;
            }
        }
        if (obj instanceof File) {
            return ((File)obj).getAbsolutePath();
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Arrays.toString((Object[])obj);
            }
            if (obj instanceof byte[]) {
                return Arrays.toString((byte[])obj);
            }
            if (obj instanceof char[]) {
                return Arrays.toString((char[])obj);
            }
            if (obj instanceof int[]) {
                return Arrays.toString((int[])obj);
            }
            if (obj instanceof float[]) {
                return Arrays.toString((float[])obj);
            }
            if (obj instanceof double[]) {
                return Arrays.toString((double[])obj);
            }
            if (obj instanceof long[]) {
                return Arrays.toString((long[])obj);
            }
            return obj.getClass().getSimpleName();
        }
        return obj.toString();
    }

    public static <T> T[] toArray(JsonArray array, Function<JsonElement, T> adapter, IntFunction<T[]> arrayFactory) {
        return StreamSupport.stream(array.spliterator(), false).map(adapter).toArray(arrayFactory);
    }

    public static byte[] getZipData(File file, String name) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry entry = zip.getEntry(name);
            if (entry == null) {
                throw new IOException("Zip Missing Entry: " + name + " File: " + file);
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)zip.getInputStream(entry));
            return byArray;
        }
    }

    public static <T> T fromJson(InputStream stream, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(stream), classOfT);
    }

    public static <T> T fromJson(byte[] data, Class<T> classOfT) throws JsonSyntaxException, JsonIOException {
        return (T)GSON.fromJson((Reader)new InputStreamReader(new ByteArrayInputStream(data)), classOfT);
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

