/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradle.common.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.gradle.common.util.HashFunction;
import net.minecraftforge.gradle.common.util.JavadocAdder;

public class McpNames {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Pattern SRG_FINDER = Pattern.compile("func_[0-9]+_[a-zA-Z_]+|field_[0-9]+_[a-zA-Z_]+|p_[\\w]+_\\d+_\\b");
    private static final Pattern METHOD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?<generic><[\\w\\W]*>\\s+)?(?<return>\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>func_[0-9]+_[a-zA-Z_]+)\\(");
    private static final Pattern FIELD_JAVADOC_PATTERN = Pattern.compile("^(?<indent>(?: {3})+|\\t+)(?!return)(?:\\w+\\s+)*(?:\\w+[\\w$.]*(?:<[\\w\\W]*>)?[\\[\\]]*)\\s+(?<name>field_[0-9]+_[a-zA-Z_]+) *(?:=|;)");
    private Map<String, String> names;
    private Map<String, String> docs;
    public final String hash;

    public static McpNames load(File data) throws IOException {
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, String> docs = new HashMap<String, String>();
        try (ZipFile zip = new ZipFile(data);){
            List entries = zip.stream().filter(e -> e.getName().endsWith(".csv")).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                CsvReader reader = new CsvReader();
                reader.setContainsHeader(true);
                CsvContainer csv = reader.read((Reader)new InputStreamReader(zip.getInputStream(entry)));
                for (CsvRow row : csv.getRows()) {
                    String searge = row.getField("searge");
                    if (searge == null) {
                        searge = row.getField("param");
                    }
                    String desc = row.getField("desc");
                    names.put(searge, row.getField("name"));
                    if (desc == null) continue;
                    docs.put(searge, desc);
                }
            }
        }
        return new McpNames(HashFunction.SHA1.hash(data), names, docs);
    }

    private McpNames(String hash, Map<String, String> names, Map<String, String> docs) {
        this.hash = hash;
        this.names = names;
        this.docs = docs;
    }

    public String rename(InputStream stream, boolean javadocs) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : CharStreams.readLines((Readable)new InputStreamReader(stream))) {
            if (javadocs) {
                this.injectJavadoc(lines, line);
            }
            lines.add(this.replaceInLine(line));
        }
        return Joiner.on((String)NEWLINE).join(lines);
    }

    public String rename(String entry) {
        return this.names.getOrDefault(entry, entry);
    }

    private void injectJavadoc(List<String> lines, String line) {
        String javadoc;
        Matcher matcher = METHOD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find()) {
            String javadoc2 = this.docs.get(matcher.group("name"));
            if (!Strings.isNullOrEmpty((String)javadoc2)) {
                McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc2, true));
            }
            return;
        }
        matcher = FIELD_JAVADOC_PATTERN.matcher(line);
        if (matcher.find() && !Strings.isNullOrEmpty((String)(javadoc = this.docs.get(matcher.group("name"))))) {
            McpNames.insertAboveAnnotations(lines, JavadocAdder.buildJavadoc(matcher.group("indent"), javadoc, false));
        }
    }

    private static void insertAboveAnnotations(List<String> list, String line) {
        int back = 0;
        while (list.get(list.size() - 1 - back).trim().startsWith("@")) {
            ++back;
        }
        list.add(list.size() - back, line);
    }

    private String replaceInLine(String line) {
        StringBuffer buf = new StringBuffer();
        Matcher matcher = SRG_FINDER.matcher(line);
        while (matcher.find()) {
            matcher.appendReplacement(buf, this.names.getOrDefault(matcher.group(), matcher.group()));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

